﻿# -*- coding: utf-8 -*-
#------------------------------------------------------------
# pelisalacarta - XBMC Plugin
# creado por rsantaella
#------------------------------------------------------------

import urlparse,urllib2,urllib,re
import os, sys

from core import logger
from core import config
from core import scrapertools
from core import jsontools
from core.item import Item
from servers import servertools

__channel__ = "disneylatino"
__category__ = "F"
__type__ = "generic"
__title__ = "disneylatino"
__language__ = "ES"
__creationdate__ = "20121216"
__vfanart__ = ""

DEBUG = config.get_setting("debug")

def isGeneric():
    return True

def mainlist(item):
    logger.info("tvalacarta.disneylatino.mainlist")

    newitem = Item(channel=__channel__, title="Todas las colecciones" , action="colecciones" , url="http://videos.disneylatino.com/_grill/more/todas-las-colecciones?r=1-0&l=0&o=0", folder=True)
    return colecciones(newitem)

def colecciones(item):
    logger.info("tvalacarta.disneylatino.colecciones")
    itemlist = []

    '''
    http://videos.disneylatino.com/_grill/more/todas-las-colecciones?r=1-0&l=0&o=0
    http://videos.disneylatino.com/_grill/more/todas-las-colecciones?r=1-0&l=0&o=8
    http://videos.disneylatino.com/_grill/more/todas-las-colecciones?r=1-0&l=0&o=16
    http://videos.disneylatino.com/_grill/more/todas-las-colecciones?r=1-0&l=8&o=24
    http://videos.disneylatino.com/_grill/more/todas-las-colecciones?r=1-0&l=16&o=32
    '''
    data = scrapertools.cachePage(item.url)
    data_json = jsontools.load_json(data)

    for stack_element in data_json:
        title = stack_element["title"]
        url = stack_element["href"]
        thumbnail = stack_element["thumb"]
        plot = "description"
        itemlist.append( Item(channel=__channel__, action="videos", title=title, url=url, thumbnail=thumbnail, plot=plot, folder=True))

    current_page = scrapertools.find_single_match(item.url,"o\=(\d+)")
    next_page = str(int(current_page)+8)
    next_page_url = item.url.replace("o="+current_page,"o="+next_page)
    itemlist.append( Item(channel=__channel__, action="colecciones", title=">> Página siguiente", url=next_page_url, folder=True))

    return itemlist

def videos(item):
    logger.info("tvalacarta.disneylatino.videos")
    itemlist = []

    data = scrapertools.cachePage(item.url)
    logger.info("data="+repr(data))
    #<script type="text/javascript">this.Grill?Grill.burger={"title":"Series | Videos Disney","cto":{"propertyId":"series","comscorekw":"disneylatinocom","account":"wdgintlatino","categoryCode":"latam","siteCode":"mh:videos","brandSegment":"family","pageName":"series","breadcrumbs":"series"},"cds":0,"pda":true,"href":"http://videos.disneylatino.com/series","stack":[{"view":"hero_universal","ref":"1-0","type":"hero","count":4,"title":null,"data":[{"id":"4ecce6766a8f5cd4b17ac5d6","slug":"theumixshow10cosas_high_videos","href":"http://videos.disneylatino.com/watch/the-u-mix-show-10-cosas-sobre-mi-nacho-4eaa2ed5873ab7e0f62edc52","title":"theumixshow10cosas_high_videos","buttons":[{"href":"http://videos.disneylatino.com/watch/the-u-mix-show-10-cosas-sobre-mi-nacho-4eaa2ed5873ab7e0f62edc52","title":"Mira ","text_color":"#000000","bg_top_color":"#fedf26","border_color":"#fedf26","style":"background: #fedf26; border: 1px solid #fedf26; color: #000000"}],"contentPosition":"right","hero":"http://cdnvideo.dolimg.com/cdn_assets/ff000fd54dd7c204c90fa610391863d28ffbe37e.jpg","hero2x":"http://cdnvideo.dolimg.com/cdn_assets/5cbc1713cf3cf29861bba09929432b6012ec4c63.jpg","hero_mobile":"http://cdnvideo.dolimg.com/cdn_assets/ef7379a5a3c6b60492434901e99b2d7365f7a5a4.jpg","video":{"duration":"1:48","duration_sec":108,"duration_iso":"T00H01M48S","badge":null,"primaryImageName":"thumb","id":"4eaa2ed5873ab7e0f62edc52","slug":"the-u-mix-show-10-cosas-sobre-mi-nacho","href":"http://videos.disneylatino.com/watch/the-u-mix-show-10-cosas-sobre-mi-nacho-4eaa2ed5873ab7e0f62edc52","title":"The U-Mix Show: 10 cosas sobre mi - Nacho","thumb":"http://cdnvideo.dolimg.com/cdn_assets/8179fd01a1f5eca533276e43086507ef035faace.jpg","description":"\u00a1Conocer\u00e1s 10 cosas sobre Nacho Riva que seguramente no sabias!","vType":"Clip","adPattern":"ACC","embedURL":"http://videos.disneylatino.com/embed/4eaa2ed5873ab7e0f62edc52","flavors":[{"bitrate":471,"format":"mp4","url":"http://media.disneyinternational.com/emea/kaltura/content/r71v1/entry/data/290/209/0_wnruckcj_0_jtr76w1g_1.mp4","id":"527c6a56396f7509b9000054","width":"480","height":"256"},{"bitrate":670,"format":"mp4","url":"http://media.disneyinternational.com/emea/kaltura/content/r71v1/entry/data/290/209/0_wnruckcj_0_80lliumz_1.mp4","id":"527c6a56396f7509b9000055","width":"640","height":"360"},{"bitrate":851,"format":"webm","url":"http://media.disneyinternational.com/emea/kaltura/content/r71v1/entry/data/290/209/0_wnruckcj_0_h54ofcg7_1.webm","id":"527c6a56396f7509b9000056","width":"640","height":"360"},{"bitrate":967,"format":"mp4","url":"http://media.disneyinternational.com/emea/kaltura/content/r71v1/entry/data/290/209/0_wnruckcj_0_ipzbl838_1.mp4","id":"527c6a56396f7509b9000057","width":"640","height":"360"},{"bitrate":1628,"format":"mp4","url":"http://media.disneyinternational.com/emea/kaltura/content/r71v1/entry/data/290/209/0_wnruckcj_0_cr0o2tag_1.mp4","id":"527c6a56396f7509b9000058","width":"1024","height":"576"},{"bitrate":2628,"format":"mp4","url":"http://media.disneyinternational.com/emea/kaltura/content/r71v1/entry/data/290/209/0_wnruckcj_0_dad9r5ck_1.mp4","id":"527c6a56396f7509b9000059","width":"1280","height":"720"},{"bitrate":4128,"format":"mp4","url":"http://media.disneyinternational.com/emea/kaltura/content/r71v1/entry/data/290/209/0_wnruckcj_0_v3txbe9o_1.mp4","id":"527c6a56396f7509b900005a","width":"1280","height":"720"},{"bitrate":375,"format":"unknown-3gp","url":"http://media.disneyinternational.com/emea/kaltura/content/r71v1/entry/data/290/209/0_wnruckcj_0_wpyh4yh6_1.3gp","id":"527c6a56396f7509b900005b","width":"320","height":"176"}],"ptitle":"The U-Mix Show","phref":"http://videos.disneylatino.com/the-u-mix-show","publish_date":"November 28, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},"background_styles":{"takeover":{"image":null,"color":"#05badf","gradient":null,"inverted":true,"bgRepeat":null}},"featured_channel_shortDesc":"Conoce los secretos de tus artistas favoritos.","section":"\u00a1Video exclusivo!","editorialColor":"light","heroSize":"standard","type":"Hero"},{"id":"4e9e69834c496f3da2455a84","slug":"violetta_diario_hl_videos_series","href":"http://videos.disneylatino.com/collections/violetta-4ea9ca53c8463450795f9637","title":"violetta_diario_HL_videos_series","buttons":[{"href":"http://videos.disneylatino.com/collections/violetta-4ea9ca53c8463450795f9637","title":"Mira los videos","bg_top_color":"#6e2a84","border_color":"#6e2a84","style":"background: #6e2a84; border: 1px solid #6e2a84"}],"contentPosition":"left","hero":"http://cdnvideo.dolimg.com/cdn_assets/341ec7c565ae78079abb1d2876078b6707636bb1.jpg","hero2x":"http://cdnvideo.dolimg.com/cdn_assets/d2a825f2182f2831bb5025d6c36099c60b6a28ae.jpg","hero_mobile":"http://cdnvideo.dolimg.com/cdn_assets/e2481fb13ba994b0abcbd5c87e0cd1d6caa7850a.jpg","video":{"duration":"1:36","duration_sec":96,"duration_iso":"T00H01M36S","badge":null,"primaryImageName":"thumb","id":"4e680ead9393a38d99ca8638","slug":"diario-de-rodaje-desafio-de-canciones","href":"http://videos.disneylatino.com/watch/diario-de-rodaje-desafio-de-canciones-4e680ead9393a38d99ca8638","title":"Desaf\u00edo de canciones: Diario de Rodaje - Violetta","thumb":"http://cdnvideo.dolimg.com/cdn_assets/b765b03f7b707314e68e6d7162d9642a48d8fa68.jpg","description":"l objetivo: nombrar todas las canciones de Violetta, \u00a1sin repetir y a m\u00e1xima velocidad!","vType":"Clip","adPattern":"ACC","embedURL":"http://videos.disneylatino.com/embed/4e680ead9393a38d99ca8638","flavors":[{"bitrate":463,"format":"mp4","url":"http://media.disneyinternational.com/emea/kaltura/content/r71v1/entry/data/274/533/0_nm7hj150_0_ps7vv4ds_1.mp4","id":"523713de30112e2bd4477e1c","width":"480","height":"256"},{"bitrate":663,"format":"mp4","url":"http://media.disneyinternational.com/emea/kaltura/content/r71v1/entry/data/274/533/0_nm7hj150_0_0xkg9tdy_1.mp4","id":"523713de30112e2bd4477e1d","width":"640","height":"360"},{"bitrate":836,"format":"webm","url":"http://media.disneyinternational.com/emea/kaltura/content/r71v1/entry/data/274/533/0_nm7hj150_0_h5oot6g5_1.webm","id":"523713de30112e2bd4477e1e","width":"640","height":"360"},{"bitrate":963,"format":"mp4","url":"http://media.disneyinternational.com/emea/kaltura/content/r71v1/entry/data/274/533/0_nm7hj150_0_tuiom3d1_1.mp4","id":"523713de30112e2bd4477e1f","width":"640","height":"360"},{"bitrate":1628,"format":"mp4","url":"http://media.disneyinternational.com/emea/kaltura/content/r71v1/entry/data/274/533/0_nm7hj150_0_7c9ihv53_1.mp4","id":"523713de30112e2bd4477e20","width":"1024","height":"576"},{"bitrate":2628,"format":"mp4","url":"http://media.disneyinternational.com/emea/kaltura/content/r71v1/entry/data/274/533/0_nm7hj150_0_k2efyb3z_1.mp4","id":"523713de30112e2bd4477e21","width":"1280","height":"720"},{"bitrate":4128,"format":"mp4","url":"http://media.disneyinternational.com/emea/kaltura/content/r71v1/entry/data/274/533/0_nm7hj150_0_hivzz1vp_1.mp4","id":"523713de30112e2bd4477e22","width":"1280","height":"720"},{"bitrate":367,"format":"unknown-3gp","url":"http://media.disneyinternational.com/emea/kaltura/content/r71v1/entry/data/274/533/0_nm7hj150_0_tdim2xgu_1.3gp","id":"523713de30112e2bd4477e23","width":"320","height":"176"}],"ptitle":"Violetta","phref":"http://videos.disneylatino.com/violetta","publish_date":"October 17, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},"background_styles":{"takeover":{"image":null,"color":"#f4c8e0","gradient":"#9b89bc","inverted":true,"bgRepeat":null}},"featured_channel_shortDesc":"Esp\u00eda el detr\u00e1s de escena de Violetta","section":"Backstage","editorialColor":"dark","titleColor":"#6e2a84","heroSize":"standard","description":"Violeta diario de rodaje","type":"Hero"},{"id":"4e9e707e28efb305d25e5e8e","slug":"teen_beach_hl_videos_series","href":"http://videos.disneylatino.com/watch/teen-beach-movie-like-me-4e72210662328e4c94588285","title":"teen_beach_HL_videos_series","buttons":[{"href":"http://videos.disneylatino.com/watch/teen-beach-movie-like-me-4e72210662328e4c94588285","title":"Mira","bg_top_color":"#b7d038","border_color":"#b7d038","style":"background: #b7d038; border: 1px solid #b7d038"}],"contentPosition":"left","hero":"http://cdnvideo.dolimg.com/cdn_assets/3130892ab54df78a19d24b6dbee942390a4a8d70.jpg","hero2x":"http://cdnvideo.dolimg.com/cdn_assets/50607f5f1307027a2af3d11a20fefe6827e1b0f0.jpg","hero_mobile":"http://cdnvideo.dolimg.com/cdn_assets/96d551a754094b117d75891b02373f2e1fa69df0.jpg","video":{"duration":"3:13","duration_sec":193,"duration_iso":"T00H03M13S","badge":null,"primaryImageName":"thumb","id":"4e72210662328e4c94588285","slug":"teen-beach-movie-like-me","href":"http://videos.disneylatino.com/watch/teen-beach-movie-like-me-4e72210662328e4c94588285","title":"Like Me - Teen Beach Movie","thumb":"http://cdnvideo.dolimg.com/cdn_assets/b7dbf460b5d9abeceb3e09e7a1b1517a1fd64fbd.jpg","description":"Los chicos y las chicas se divierten.","vType":"Music Video","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e72210662328e4c94588285","flavors":[{"bitrate":473,"format":"mp4","url":"http://media.disneyinternational.com/emea/kaltura/content/r71v1/entry/data/280/837/0_2dj95y1z_0_nb66zond_1.mp4","id":"5241a375c697a13bc2000074","width":"480","height":"256"},{"bitrate":673,"format":"mp4","url":"http://media.disneyinternational.com/emea/kaltura/content/r71v1/entry/data/280/837/0_2dj95y1z_0_v82sg5k3_1.mp4","id":"5241a375c697a13bc2000075","width":"640","height":"360"},{"bitrate":855,"format":"webm","url":"http://media.disneyinternational.com/emea/kaltura/content/r71v1/entry/data/280/837/0_2dj95y1z_0_h26a2vc5_1.webm","id":"5241a375c697a13bc2000076","width":"640","height":"360"},{"bitrate":974,"format":"mp4","url":"http://media.disneyinternational.com/emea/kaltura/content/r71v1/entry/data/280/837/0_2dj95y1z_0_pbxq1bf7_1.mp4","id":"5241a375c697a13bc2000077","width":"640","height":"360"},{"bitrate":1628,"format":"mp4","url":"http://media.disneyinternational.com/emea/kaltura/content/r71v1/entry/data/280/837/0_2dj95y1z_0_0vavyip1_1.mp4","id":"5241a375c697a13bc2000078","width":"1024","height":"576"},{"bitrate":2644,"format":"mp4","url":"http://media.disneyinternational.com/emea/kaltura/content/r71v1/entry/data/280/837/0_2dj95y1z_0_1pi1wiy6_1.mp4","id":"5241a375c697a13bc2000079","width":"1280","height":"720"},{"bitrate":4145,"format":"mp4","url":"http://media.disneyinternational.com/emea/kaltura/content/r71v1/entry/data/280/837/0_2dj95y1z_0_2wn6rllv_1.mp4","id":"5241a375c697a13bc200007a","width":"1920","height":"1072"},{"bitrate":376,"format":"unknown-3gp","url":"http://media.disneyinternational.com/emea/kaltura/content/r71v1/entry/data/280/837/0_2dj95y1z_0_uxnhsjst_1.3gp","id":"5241a375c697a13bc200007b","width":"320","height":"176"}],"publish_date":"October 18, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},"background_styles":{"takeover":{"image":null,"color":"#ff9c00","gradient":null,"inverted":true,"bgRepeat":null}},"featured_channel_shortDesc":"Baila y canta con todos los videos de Teen Beach Movie.","editorialColor":"light","heroSize":"standard","description":"Noviembre videos series","type":"Hero"},{"id":"4e9e71bfccbf9d54dff52724","slug":"swampy_hl_videos_series","href":"http://videos.disneylatino.com/collections/where-is-my-water-4eae5ef85195c43a16dbc569","title":"swampy_HL_videos_series","buttons":[{"href":"http://videos.disneylatino.com/collections/where-is-my-water-4eae5ef85195c43a16dbc569","title":"Mira","bg_top_color":"#b7d038","border_color":"#b7d038","style":"background: #b7d038; border: 1px solid #b7d038"}],"contentPosition":"right","hero":"http://cdnvideo.dolimg.com/cdn_assets/12c5b8753069c27b8dfe2bc3a3524cda71de9b89.jpg","hero2x":"http://cdnvideo.dolimg.com/cdn_assets/93c2251495e7afdad5b46eef51ac21900dd8c532.jpg","hero_mobile":"http://cdnvideo.dolimg.com/cdn_assets/74cab399f75ca7d7ad8374c86965b0532c7aaa93.jpg","video":{"duration":"2:08","duration_sec":128,"duration_iso":"T00H02M08S","badge":null,"primaryImageName":"thumb","id":"4e680d98abc7838d99da8638","slug":"wheres-my-water-episodio-1-presentando-a-swampy","href":"http://videos.disneylatino.com/watch/wheres-my-water-episodio-1-presentando-a-swampy-4e680d98abc7838d99da8638","title":"Episodio 1: Presentando a Swampy - Where's My Water?","thumb":"http://cdnvideo.dolimg.com/cdn_assets/c319e02b4400574bcc2dc50e803e62c507a04a02.jpg","description":"Swampy confunde un extinguidor con una mochila-cohete.","vType":"Full Episode - Web","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e680d98abc7838d99da8638","flavors":[{"bitrate":468,"format":"mp4","url":"http://media.disneyinternational.com/emea/kaltura/content/r71v1/entry/data/273/341/0_1msrhvar_0_i3k75htf_1.mp4","id":"523712bc30112e2bdb46f642","width":"480","height":"256"},{"bitrate":666,"format":"mp4","url":"http://media.disneyinternational.com/emea/kaltura/content/r71v1/entry/data/273/341/0_1msrhvar_0_z26of0qv_1.mp4","id":"523712bc30112e2bdb46f643","width":"640","height":"360"},{"bitrate":836,"format":"webm","url":"http://media.disneyinternational.com/emea/kaltura/content/r71v1/entry/data/273/341/0_1msrhvar_0_kvkablz3_1.webm","id":"523712bc30112e2bdb46f644","width":"640","height":"360"},{"bitrate":963,"format":"mp4","url":"http://media.disneyinternational.com/emea/kaltura/content/r71v1/entry/data/273/341/0_1msrhvar_0_mycrt1gn_1.mp4","id":"523712bc30112e2bdb46f645","width":"640","height":"360"},{"bitrate":1544,"format":"mp4","url":"http://media.disneyinternational.com/emea/kaltura/content/r71v1/entry/data/273/341/0_1msrhvar_0_9z6nl1y2_1.mp4","id":"523712bc30112e2bdb46f646","width":"1024","height":"576"},{"bitrate":2627,"format":"mp4","url":"http://media.disneyinternational.com/emea/kaltura/content/r71v1/entry/data/273/341/0_1msrhvar_0_kt1vz0f9_1.mp4","id":"523712bc30112e2bdb46f647","width":"1280","height":"720"},{"bitrate":4127,"format":"mp4","url":"http://media.disneyinternational.com/emea/kaltura/content/r71v1/entry/data/273/341/0_1msrhvar_0_9ykchzrf_1.mp4","id":"523712bc30112e2bdb46f648","width":"1920","height":"1072"},{"bitrate":370,"format":"unknown-3gp","url":"http://media.disneyinternational.com/emea/kaltura/content/r71v1/entry/data/273/341/0_1msrhvar_0_0yiruhc4_1.3gp","id":"523712bc30112e2bdb46f649","width":"320","height":"176"}],"ptitle":"Where's my water?","phref":"http://videos.disneylatino.com/where-s-my-water-presents-swampy-s-underground-adventures","publish_date":"October 18, 2013","cta_button_title":"Watch Now","type":"Video"},"background_styles":{"takeover":{"image":null,"color":"#0d3030","gradient":null,"inverted":true,"bgRepeat":null}},"featured_channel_shortDesc":"Sum\u00e9rgete con todos los videos de tu reptil favorito.","section":"M\u00e1s Swampy","editorialColor":"light","heroSize":"standard","description":"Noviembre videos series","type":"Hero"}],"style":{"images":{}}},{"view":"sidekick_video","ref":"1-1","type":"video","count":1,"title":"Destacado","data":[{"duration":"0:45","duration_sec":45,"duration_iso":"T00H00M45S","badge":null,"primaryImageName":"thumb","id":"4e96ccb35213356e44f44d51","slug":"phineas-y-ferb-te-deseamos-feliz-navidad","href":"http://videos.disneylatino.com/watch/phineas-y-ferb-te-deseamos-feliz-navidad-4e96ccb35213356e44f44d51","title":" Te deseamos Feliz Navidad - Phineas y Ferb","thumb":"http://cdnvideo.dolimg.com/cdn_assets/6be074dd7e230715270e2f9da0b577dc9b9d9cac.jpg","description":"\u00a1Canta Feliz Navidad a todos!","analytics":"vid||||0_fip5ti4j|dc_phf_mv_navidad","adId":"0_fip5ti4j","analyticsId":"0_fip5ti4j","vType":"Music Video","adPattern":"C","externals":[{"account":"1068292","created_at":"2013-10-23T11:36:23-07:00","data":{"objectType":"KalturaMediaEntry","mediaType":"1","conversionQuality":"3945191","sourceType":"1","searchProviderType":null,"searchProviderId":null,"creditUserName":null,"creditUrl":null,"mediaDate":null,"dataUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/flvclipper/entry_id/0_fip5ti4j/version/0","flavorParamsIds":"0,301991,487111,525091,525101,525111,525121,525131,525141","plays":"1","views":"1","width":"1920","height":"1072","duration":"45","msDuration":"45272","durationType":null,"id":"0_fip5ti4j","name":"Phineas y Ferb: Te deseamos Feliz Navidad","description":"\u00a1Canta Feliz Navidad a todos!","partnerId":"1068292","userId":"cperales","creatorId":"cperales","tags":"displayname_cperales","adminTags":null,"categories":null,"categoriesIds":null,"status":"2","moderationStatus":"6","moderationCount":"0","type":"1","createdAt":"1382551573","updatedAt":"1384797751","rank":"0","totalRank":"0","votes":"0","groupId":null,"partnerData":null,"downloadUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/raw/entry_id/0_fip5ti4j/version/0","searchText":"_KAL_NET_ _1068292_ _MEDIA_TYPE_1|  Phineas y Ferb: Te deseamos Feliz Navidad displayname_cperales \u00a1Canta Feliz Navidad a todos! ","licenseType":null,"version":"0","thumbnailUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/thumbnail/entry_id/0_fip5ti4j/version/100000","accessControlId":"1218511","startDate":null,"endDate":null,"referenceId":null,"replacingEntryId":null,"replacedEntryId":null,"replacementStatus":"0","partnerSortValue":"0","conversionProfileId":"3945191","rootEntryId":"0_fip5ti4j","operationAttributes":null,"entitledUsersEdit":null,"entitledUsersPublish":null,"Locale":"es_419","LongName":"Phineas y Ferb: Te deseamos Feliz Navidad","ShortTitle":"dc_phf_mv_navidad","LongDescription":"\u00a1Canta Feliz Navidad a todos!","PropertyName":"phineas and ferb","PropertyCode":"phf","LocalPropertyName":"Phineas ","SiteSection":"tv-dc","ContentType":"music video"},"id":"52681725c697a1714a00002c","source":"kaltura","updated_at":"2013-11-18T11:08:35-08:00","video_id":"0_fip5ti4j"}],"embedURL":"http://videos.disneylatino.com/embed/4e96ccb35213356e44f44d51","flavors":[{"bitrate":472,"format":"mp4","url":"http://media.disneyinternational.com/emea/kaltura/content/r71v1/entry/data/286/851/0_fip5ti4j_0_2czipds6_1.mp4","id":"52681726c697a1714a00002d","width":"480","height":"256"},{"bitrate":671,"format":"mp4","url":"http://media.disneyinternational.com/emea/kaltura/content/r71v1/entry/data/286/851/0_fip5ti4j_0_ol9oox9y_1.mp4","id":"52681726c697a1714a00002e","width":"640","height":"360"},{"bitrate":858,"format":"webm","url":"http://media.disneyinternational.com/emea/kaltura/content/r71v1/entry/data/286/851/0_fip5ti4j_0_g6eay2gl_1.webm","id":"52681726c697a1714a00002f","width":"640","height":"360"},{"bitrate":963,"format":"mp4","url":"http://media.disneyinternational.com/emea/kaltura/content/r71v1/entry/data/286/851/0_fip5ti4j_0_ajyx63r8_1.mp4","id":"52681726c697a1714a000030","width":"640","height":"360"},{"bitrate":1628,"format":"mp4","url":"http://media.disneyinternational.com/emea/kaltura/content/r71v1/entry/data/286/851/0_fip5ti4j_0_i6uz1yfl_1.mp4","id":"52681726c697a1714a000031","width":"1024","height":"576"},{"bitrate":2628,"format":"mp4","url":"http://media.disneyinternational.com/emea/kaltura/content/r71v1/entry/data/286/851/0_fip5ti4j_0_s4j2i72v_1.mp4","id":"52681726c697a1714a000032","width":"1280","height":"720"},{"bitrate":4128,"format":"mp4","url":"http://media.disneyinternational.com/emea/kaltura/content/r71v1/entry/data/286/851/0_fip5ti4j_0_tzfha2e5_1.mp4","id":"52681726c697a1714a000033","width":"1920","height":"1072"},{"bitrate":387,"format":"unknown-3gp","url":"http://media.disneyinternational.com/emea/kaltura/content/r71v1/entry/data/286/851/0_fip5ti4j_0_39zwdl6f_1.3gp","id":"52681726c697a1714a000034","width":"320","height":"176"}],"next":[{"duration":"24:06","duration_sec":1446,"duration_iso":"T00H24M06S","badge":null,"primaryImageName":"thumb","id":"4ec501408475a28379a426bd","slug":"episodio-63-la-historia-de-la-abejita-de-minnie-la-casa-de-mickey-mouse","href":"http://videos.disneylatino.com/watch/episodio-63-la-historia-de-la-abejita-de-minnie-la-casa-de-mickey-mouse-4ec501408475a28379a426bd","title":"Episodio 63: La historia de la abejita de Minnie\u00a0- La casa de Mickey Mouse","thumb":"http://cdnvideo.dolimg.com/cdn_assets/8d6d01ab052431dad373b814d2d01306dc5bfe8b.jpg","description":"Este episodio es realmente imperdible. \u00a1M\u00edralo!","vType":"Full Episode - TV","externals":[{"account":"1068292","created_at":"2013-11-29T04:36:25-08:00","data":{"objectType":"KalturaMediaEntry","mediaType":"1","conversionQuality":"3945191","sourceType":"1","searchProviderType":null,"searchProviderId":null,"creditUserName":null,"creditUrl":null,"mediaDate":null,"dataUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/flvclipper/entry_id/0_higbvawu/version/0","flavorParamsIds":"0,301991,487111,525091,525101,525111,525121,525131,525141","plays":"0","views":"0","width":"720","height":"480","duration":"1446","msDuration":"1446000","durationType":null,"id":"0_higbvawu","name":"Episodio 63: La historia de la abejita de Minnie\u00a0- La casa de Mickey Mouse","description":"Este episodio es realmente imperdible. \u00a1M\u00edralo!","partnerId":"1068292","userId":"cperales","creatorId":"cperales","tags":null,"adminTags":null,"categories":null,"categoriesIds":null,"status":"2","moderationStatus":"6","moderationCount":"0","type":"1","createdAt":"1385727116","updatedAt":"1387293303","rank":"0","totalRank":"0","votes":"0","groupId":null,"partnerData":null,"downloadUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/raw/entry_id/0_higbvawu/version/0","searchText":"_KAL_NET_ _1068292_ _MEDIA_TYPE_1|  Episodio 63: La historia de la abejita de Minnie\u00a0- La casa de Mickey Mouse Este episodio es realmente imperdible. \u00a1M\u00edralo! ","licenseType":null,"version":"0","thumbnailUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/thumbnail/entry_id/0_higbvawu/version/100000","accessControlId":"1218511","startDate":null,"endDate":null,"referenceId":null,"replacingEntryId":null,"replacedEntryId":null,"replacementStatus":"0","partnerSortValue":"0","conversionProfileId":"3945191","rootEntryId":"0_higbvawu","operationAttributes":null,"entitledUsersEdit":null,"entitledUsersPublish":null,"thumbnail_updatedAt":"1385727137","Locale":"es_419","LongName":"Episodio 63: La historia de la abejita de Minnie\u00a0- La casa de Mickey Mouse","ShortTitle":"dj_mmch_temp1_ep63","LongDescription":"Este episodio es realmente imperdible. \u00a1M\u00edralo!","PropertyName":"mickey mouse clubhouse","PropertyCode":"mch","LocalPropertyName":"La casa de Mickey Mouse","SiteSection":"tv-djr","ContentType":"full episode","AgeConsent":"No Age Consent"},"id":"52988a4838b2bc0fdf000035","source":"kaltura","updated_at":"2013-12-18T05:13:17-08:00","video_id":"0_higbvawu"}],"embedURL":"http://videos.disneylatino.com/embed/4ec501408475a28379a426bd","ptitle":"La casa de Mickey Mouse","phref":"http://videos.disneylatino.com/la-casa-de-mickey-mouse","publish_date":"December 18, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"2:12","duration_sec":132,"duration_iso":"T00H02M12S","badge":null,"primaryImageName":"thumb","id":"4edbbdabeed5b193848b0eec","slug":"un-viaje-especial-princesita-sofia","href":"http://videos.disneylatino.com/watch/un-viaje-especial-princesita-sofia-4edbbdabeed5b193848b0eec","title":"Un viaje especial - Princesita Sof\u00eda","thumb":"http://cdnvideo.dolimg.com/cdn_assets/90f9ff4aab1b7b8590efccdbc1a862aaac4736f2.jpg","description":"Disfruta de este video musical de una de tus series favoritas.","vType":"Music Video","externals":[{"account":"1068292","created_at":"2013-12-17T06:36:34-08:00","data":{"objectType":"KalturaMediaEntry","mediaType":"1","conversionQuality":"3945191","sourceType":"1","searchProviderType":null,"searchProviderId":null,"creditUserName":null,"creditUrl":null,"mediaDate":null,"dataUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/flvclipper/entry_id/0_c0bl4ap8/version/0","flavorParamsIds":"0,301991,487111,525091,525101,525111,525121,525131,525141","plays":"0","views":"0","width":"1920","height":"1072","duration":"132","msDuration":"132000","durationType":null,"id":"0_c0bl4ap8","name":"Un viaje especial - Princesita Sof\u00eda","description":"Disfruta de este video musical de una de tus series favoritas.","partnerId":"1068292","userId":"cperales","creatorId":"cperales","tags":"displayname_cperales","adminTags":null,"categories":null,"categoriesIds":null,"status":"2","moderationStatus":"6","moderationCount":"0","type":"1","createdAt":"1387287810","updatedAt":"1387288266","rank":"0","totalRank":"0","votes":"0","groupId":null,"partnerData":null,"downloadUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/raw/entry_id/0_c0bl4ap8/version/0","searchText":"_KAL_NET_ _1068292_ _MEDIA_TYPE_1|  Un viaje especial - Princesita Sof\u00eda displayname_cperales Disfruta de este video musical de una de tus series favoritas. ","licenseType":null,"version":"0","thumbnailUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/thumbnail/entry_id/0_c0bl4ap8/version/100000","accessControlId":"1218511","startDate":null,"endDate":null,"referenceId":null,"replacingEntryId":null,"replacedEntryId":null,"replacementStatus":"0","partnerSortValue":"0","conversionProfileId":"3945191","rootEntryId":"0_c0bl4ap8","operationAttributes":null,"entitledUsersEdit":null,"entitledUsersPublish":null,"Locale":"es_419","LongName":"Un viaje especial - Princesita Sof\u00eda","ShortTitle":"dj_sofia_mv_ride","LongDescription":"Disfruta de este video musical de una de tus series favoritas.","PropertyName":"sofia the first","PropertyCode":"sof","LocalPropertyName":"Princesita Sof\u00eda","SiteSection":"tv-djr","ContentType":"music video","AgeConsent":"No Age Consent","thumbnail_updatedAt":"1387287822"},"id":"52b0616f38b2bc766f000017","source":"kaltura","updated_at":"2013-12-18T05:07:37-08:00","video_id":"0_c0bl4ap8"}],"embedURL":"http://videos.disneylatino.com/embed/4edbbdabeed5b193848b0eec","ptitle":"Princesita Sof\u00eda","phref":"http://videos.disneylatino.com/princesita-sof-a","publish_date":"December 18, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"2:21","duration_sec":141,"duration_iso":"T00H02M21S","badge":null,"primaryImageName":"thumb","id":"4edbbdafae63f193848b0eec","slug":"tu-amistad-podra-ayudar-princesita-sofia","href":"http://videos.disneylatino.com/watch/tu-amistad-podra-ayudar-princesita-sofia-4edbbdafae63f193848b0eec","title":"Tu amistad podr\u00e1 ayudar - Princesita Sof\u00eda","thumb":"http://cdnvideo.dolimg.com/cdn_assets/e01c44af58590846bebe3174cb30512e28840ebd.jpg","description":"Disfruta de este video musical de una de tus series favoritas.","vType":"Music Video","externals":[{"account":"1068292","created_at":"2013-12-17T06:36:37-08:00","data":{"objectType":"KalturaMediaEntry","mediaType":"1","conversionQuality":"3945191","sourceType":"1","searchProviderType":null,"searchProviderId":null,"creditUserName":null,"creditUrl":null,"mediaDate":null,"dataUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/flvclipper/entry_id/0_6xck02lw/version/0","flavorParamsIds":"0,301991,487111,525091,525101,525111,525121,525131,525141","plays":"1","views":"2","width":"1920","height":"1072","duration":"141","msDuration":"141000","durationType":null,"id":"0_6xck02lw","name":"Tu amistad podr\u00e1 ayudar - Princesita Sof\u00eda","description":"Disfruta de este video musical de una de tus series favoritas.","partnerId":"1068292","userId":"cperales","creatorId":"cperales","tags":"displayname_cperales","adminTags":null,"categories":null,"categoriesIds":null,"status":"2","moderationStatus":"6","moderationCount":"0","type":"1","createdAt":"1387287380","updatedAt":"1387288278","rank":"0","totalRank":"0","votes":"0","groupId":null,"partnerData":null,"downloadUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/raw/entry_id/0_6xck02lw/version/0","searchText":"_KAL_NET_ _1068292_ _MEDIA_TYPE_1|  Tu amistad podr\u00e1 ayudar - Princesita Sof\u00eda displayname_cperales Disfruta de este video musical de una de tus series favoritas. ","licenseType":null,"version":"0","thumbnailUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/thumbnail/entry_id/0_6xck02lw/version/100000","accessControlId":"1218511","startDate":null,"endDate":null,"referenceId":null,"replacingEntryId":null,"replacedEntryId":null,"replacementStatus":"0","partnerSortValue":"0","conversionProfileId":"3945191","rootEntryId":"0_6xck02lw","operationAttributes":null,"entitledUsersEdit":null,"entitledUsersPublish":null,"Locale":"es_419","LongName":"Tu amistad podr\u00e1 ayudar - Princesita Sof\u00eda","ShortTitle":"dj_sofia_mv_all_you_need","LongDescription":"Disfruta de este video musical de una de tus series favoritas.","PropertyName":"sofia the first","PropertyCode":"sof","LocalPropertyName":"Princesita Sof\u00eda","SiteSection":"tv-djr","ContentType":"music video","AgeConsent":"No Age Consent","thumbnail_updatedAt":"1387287391"},"id":"52b0617338b2bc766f000027","source":"kaltura","updated_at":"2013-12-18T05:01:50-08:00","video_id":"0_6xck02lw"}],"embedURL":"http://videos.disneylatino.com/embed/4edbbdafae63f193848b0eec","ptitle":"Princesita Sof\u00eda","phref":"http://videos.disneylatino.com/princesita-sof-a","publish_date":"December 18, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"26:20","duration_sec":1580,"duration_iso":"T00H26M20S","badge":null,"primaryImageName":"thumb","id":"4ec80b128322a2adc774b8ac","slug":"episodio-66-el-embrollo-magico-de-goofy-la-casa-de-mickey-mouse","href":"http://videos.disneylatino.com/watch/episodio-66-el-embrollo-magico-de-goofy-la-casa-de-mickey-mouse-4ec80b128322a2adc774b8ac","title":"Episodio 66: El embrollo m\u00e1gico de Goofy - La casa de Mickey Mouse","thumb":"http://cdnvideo.dolimg.com/cdn_assets/2c17b0164d9f1ff463f91d71ce960c3e9ede6390.jpg","description":"\u00bfEst\u00e1s preparado? Disfruta al m\u00e1ximo de este episodio.","vType":"Full Episode - TV","externals":[{"account":"1068292","created_at":"2013-12-01T14:36:19-08:00","data":{"objectType":"KalturaMediaEntry","mediaType":"1","conversionQuality":"3945191","sourceType":"1","searchProviderType":null,"searchProviderId":null,"creditUserName":null,"creditUrl":null,"mediaDate":null,"dataUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/flvclipper/entry_id/0_12kb6o64/version/0","flavorParamsIds":"0,301991,487111,525091,525101,525111,525121,525131,525141","plays":"0","views":"0","width":"720","height":"480","duration":"1580","msDuration":"1580000","durationType":null,"id":"0_12kb6o64","name":"Episodio 66: El embrollo m\u00e1gico de Goofy - La casa de Mickey Mouse","description":"\u00bfEst\u00e1s preparado? Disfruta al m\u00e1ximo de este episodio.","partnerId":"1068292","userId":"cperales","creatorId":"cperales","tags":null,"adminTags":null,"categories":null,"categoriesIds":null,"status":"2","moderationStatus":"6","moderationCount":"0","type":"1","createdAt":"1385934670","updatedAt":"1387215702","rank":"0","totalRank":"0","votes":"0","groupId":null,"partnerData":null,"downloadUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/raw/entry_id/0_12kb6o64/version/0","searchText":"_KAL_NET_ _1068292_ _MEDIA_TYPE_1|  Episodio 66: El embrollo m\u00e1gico de Goofy - La casa de Mickey Mouse \u00bfEst\u00e1s preparado? Disfruta al m\u00e1ximo de este episodio. ","licenseType":null,"version":"0","thumbnailUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/thumbnail/entry_id/0_12kb6o64/version/100000","accessControlId":"1218511","startDate":null,"endDate":null,"referenceId":null,"replacingEntryId":null,"replacedEntryId":null,"replacementStatus":"0","partnerSortValue":"0","conversionProfileId":"3945191","rootEntryId":"0_12kb6o64","operationAttributes":null,"entitledUsersEdit":null,"entitledUsersPublish":null,"Locale":"es_419","LongName":"Episodio 66: El embrollo m\u00e1gico de Goofy - La casa de Mickey Mouse","ShortTitle":"dj_mmch_temp1_ep66","LongDescription":"\u00bfEst\u00e1s preparado? Disfruta al m\u00e1ximo de este episodio.","PropertyName":"mickey mouse clubhouse","PropertyCode":"mch","LocalPropertyName":"La casa de Mickey Mouse","SiteSection":"tv-djr","ContentType":"full episode","AgeConsent":"No Age Consent","thumbnail_updatedAt":"1385934680"},"id":"529bb9e338b2bc1ef9000008","source":"kaltura","updated_at":"2013-12-18T04:57:16-08:00","video_id":"0_12kb6o64"}],"embedURL":"http://videos.disneylatino.com/embed/4ec80b128322a2adc774b8ac","ptitle":"La casa de Mickey Mouse","phref":"http://videos.disneylatino.com/la-casa-de-mickey-mouse","publish_date":"December 18, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"24:05","duration_sec":1445,"duration_iso":"T00H24M05S","badge":null,"primaryImageName":"thumb","id":"4ec7fda6b28de21e1e9b0f3a","slug":"episodio-65-la-gran-sorpresa-de-mickey-la-casa-de-mickey-mouse","href":"http://videos.disneylatino.com/watch/episodio-65-la-gran-sorpresa-de-mickey-la-casa-de-mickey-mouse-4ec7fda6b28de21e1e9b0f3a","title":"Episodio 65: La gran sorpresa de Mickey - La casa de Mickey Mouse","thumb":"http://cdnvideo.dolimg.com/cdn_assets/ccde25f0b5234a7cf85a1ca9808194d63c28389d.jpg","description":"\u00bfNo has visto este episodio? Aqu\u00ed tienes una oportunidad de disfrutarlo completo.","vType":"Full Episode - TV","externals":[{"account":"1068292","created_at":"2013-12-01T13:36:17-08:00","data":{"objectType":"KalturaMediaEntry","mediaType":"1","conversionQuality":"3945191","sourceType":"1","searchProviderType":null,"searchProviderId":null,"creditUserName":null,"creditUrl":null,"mediaDate":null,"dataUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/flvclipper/entry_id/0_v8hy4cqt/version/0","flavorParamsIds":"0,301991,487111,525091,525101,525111,525121,525131,525141","plays":"0","views":"0","width":"720","height":"480","duration":"1445","msDuration":"1445000","durationType":null,"id":"0_v8hy4cqt","name":"Episodio 65: La gran sorpresa de Mickey - La casa de Mickey Mouse","description":"\u00bfNo has visto este episodio? Aqu\u00ed tienes una oportunidad de disfrutarlo completo.","partnerId":"1068292","userId":"cperales","creatorId":"cperales","tags":null,"adminTags":null,"categories":null,"categoriesIds":null,"status":"2","moderationStatus":"6","moderationCount":"0","type":"1","createdAt":"1385932252","updatedAt":"1387215693","rank":"0","totalRank":"0","votes":"0","groupId":null,"partnerData":null,"downloadUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/raw/entry_id/0_v8hy4cqt/version/0","searchText":"_KAL_NET_ _1068292_ _MEDIA_TYPE_1|  Episodio 65: La gran sorpresa de Mickey - La casa de Mickey Mouse \u00bfNo has visto este episodio? Aqu\u00ed tienes una oportunidad de disfrutarlo completo. ","licenseType":null,"version":"0","thumbnailUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/thumbnail/entry_id/0_v8hy4cqt/version/100000","accessControlId":"1218511","startDate":null,"endDate":null,"referenceId":null,"replacingEntryId":null,"replacedEntryId":null,"replacementStatus":"0","partnerSortValue":"0","conversionProfileId":"3945191","rootEntryId":"0_v8hy4cqt","operationAttributes":null,"entitledUsersEdit":null,"entitledUsersPublish":null,"Locale":"es_419","LongName":"Episodio 65: La gran sorpresa de Mickey - La casa de Mickey Mouse","ShortTitle":"dj_mmch_temp1_ep65","LongDescription":"\u00bfNo has visto este episodio? Aqu\u00ed tienes una oportunidad de disfrutarlo completo.","PropertyName":"mickey mouse clubhouse","PropertyCode":"mch","LocalPropertyName":"La casa de Mickey Mouse","SiteSection":"tv-djr","ContentType":"full episode","AgeConsent":"No Age Consent","thumbnail_updatedAt":"1385932263"},"id":"529babd038b2bc754f000011","source":"kaltura","updated_at":"2013-12-18T04:51:20-08:00","video_id":"0_v8hy4cqt"}],"embedURL":"http://videos.disneylatino.com/embed/4ec7fda6b28de21e1e9b0f3a","ptitle":"La casa de Mickey Mouse","phref":"http://videos.disneylatino.com/la-casa-de-mickey-mouse","publish_date":"December 18, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"24:06","duration_sec":1446,"duration_iso":"T00H24M06S","badge":null,"primaryImageName":"thumb","id":"4ec825e0a50edd7a0a427967","slug":"episodio-40-la-antigua-cancion-del-viejo-macdonalds-oso-agente-especial","href":"http://videos.disneylatino.com/watch/episodio-40-la-antigua-cancion-del-viejo-macdonalds-oso-agente-especial-4ec825e0a50edd7a0a427967","title":"Episodio 40: La antigua canci\u00f3n del viejo MacDonald\u2019s - Oso: Agente Especial","thumb":"http://cdnvideo.dolimg.com/cdn_assets/722100d62f47e72a18f48840f156bd2e63f7ced7.jpg","description":"No te pierdas los momentos inolvidables que incluye este episodio.","vType":"Full Episode - TV","externals":[{"account":"1068292","created_at":"2013-12-01T16:36:15-08:00","data":{"objectType":"KalturaMediaEntry","mediaType":"1","conversionQuality":"3945191","sourceType":"1","searchProviderType":null,"searchProviderId":null,"creditUserName":null,"creditUrl":null,"mediaDate":null,"dataUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/flvclipper/entry_id/0_xu8qejmy/version/0","flavorParamsIds":"0,301991,487111,525091,525101,525111,525121,525131,525141","plays":"0","views":"0","width":"720","height":"480","duration":"1446","msDuration":"1446000","durationType":null,"id":"0_xu8qejmy","name":"Episodio 40: La antigua canci\u00f3n del viejo MacDonald\u2019s - Oso: Agente Especial","description":"No te pierdas los momentos inolvidables que incluye este episodio.","partnerId":"1068292","userId":"cperales","creatorId":"cperales","tags":null,"adminTags":null,"categories":null,"categoriesIds":null,"status":"2","moderationStatus":"6","moderationCount":"0","type":"1","createdAt":"1385941127","updatedAt":"1387213366","rank":"0","totalRank":"0","votes":"0","groupId":null,"partnerData":null,"downloadUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/raw/entry_id/0_xu8qejmy/version/0","searchText":"_KAL_NET_ _1068292_ _MEDIA_TYPE_1|  Episodio 40: La antigua canci\u00f3n del viejo MacDonald\u2019s - Oso: Agente Especial No te pierdas los momentos inolvidables que incluye este episodio. ","licenseType":null,"version":"0","thumbnailUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/thumbnail/entry_id/0_xu8qejmy/version/100000","accessControlId":"1218511","startDate":null,"endDate":null,"referenceId":null,"replacingEntryId":null,"replacedEntryId":null,"replacementStatus":"0","partnerSortValue":"0","conversionProfileId":"3945191","rootEntryId":"0_xu8qejmy","operationAttributes":null,"entitledUsersEdit":null,"entitledUsersPublish":null,"Locale":"es_419","LongName":"Episodio 40: La antigua canci\u00f3n del viejo MacDonald\u2019s - Oso: Agente Especial","ShortTitle":"dj_oso_temp1_ep40","LongDescription":"No te pierdas los momentos inolvidables que incluye este episodio.","PropertyName":"special agent oso","PropertyCode":"oso","LocalPropertyName":"Oso: Agente Especial","SiteSection":"tv-djr","ContentType":"full episode","AgeConsent":"No Age Consent","thumbnail_updatedAt":"1385941150"},"id":"529bd5fe38b2bc6f76000005","source":"kaltura","updated_at":"2013-12-18T04:45:10-08:00","video_id":"0_xu8qejmy"}],"embedURL":"http://videos.disneylatino.com/embed/4ec825e0a50edd7a0a427967","ptitle":"Oso: Agente Especial","phref":"http://videos.disneylatino.com/oso-agente-especial","publish_date":"December 18, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"24:11","duration_sec":1451,"duration_iso":"T00H24M11S","badge":null,"primaryImageName":"thumb","id":"4ec7f03ddd75440b2f47e691","slug":"episodio-26-peter-pan-regresa-parte-2-jake-y-los-piratas-del-pais-de-nunca-jamas","href":"http://videos.disneylatino.com/watch/episodio-26-peter-pan-regresa-parte-2-jake-y-los-piratas-del-pais-de-nunca-jamas-4ec7f03ddd75440b2f47e691","title":"Episodio 26: Peter Pan regresa - Parte II - Jake y los piratas del pa\u00eds de Nunca Jam\u00e1s ","thumb":"http://cdnvideo.dolimg.com/cdn_assets/f030fcea11b345b9783b7e0599bf19f5cb717dab.jpg","description":"En este episodio, tus personajes favoritos te atrapar\u00e1n una vez m\u00e1s. No dejes de verlo.","vType":"Full Episode - TV","externals":[{"account":"1068292","created_at":"2013-12-01T12:36:17-08:00","data":{"objectType":"KalturaMediaEntry","mediaType":"1","conversionQuality":"3945191","sourceType":"1","searchProviderType":null,"searchProviderId":null,"creditUserName":null,"creditUrl":null,"mediaDate":null,"dataUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/flvclipper/entry_id/0_688mf11n/version/0","flavorParamsIds":"0,301991,487111,525091,525101,525111,525121,525131,525141","plays":"0","views":"0","width":"1920","height":"1072","duration":"1451","msDuration":"1451000","durationType":null,"id":"0_688mf11n","name":"Episodio 26: Peter Pan regresa - Parte II - Jake y los piratas del pa\u00eds de Nunca Jam\u00e1s ","description":"En este episodio, tus personajes favoritos te atrapar\u00e1n una vez m\u00e1s. No dejes de verlo. ","partnerId":"1068292","userId":"cperales","creatorId":"cperales","tags":null,"adminTags":null,"categories":null,"categoriesIds":null,"status":"2","moderationStatus":"6","moderationCount":"0","type":"1","createdAt":"1385928593","updatedAt":"1387215205","rank":"0","totalRank":"0","votes":"0","groupId":null,"partnerData":null,"downloadUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/raw/entry_id/0_688mf11n/version/0","searchText":"_KAL_NET_ _1068292_ _MEDIA_TYPE_1|  Episodio 26: Peter Pan regresa - Parte II - Jake y los piratas del pa\u00eds de Nunca Jam\u00e1s En este episodio, tus personajes favoritos te atrapar\u00e1n una vez m\u00e1s. No dejes de verlo. ","licenseType":null,"version":"0","thumbnailUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/thumbnail/entry_id/0_688mf11n/version/100000","accessControlId":"1218511","startDate":null,"endDate":null,"referenceId":null,"replacingEntryId":null,"replacedEntryId":null,"replacementStatus":"0","partnerSortValue":"0","conversionProfileId":"3945191","rootEntryId":"0_688mf11n","operationAttributes":null,"entitledUsersEdit":null,"entitledUsersPublish":null,"Locale":"es_419","LongName":"Episodio 26: Peter Pan regresa - Parte II - Jake y los piratas del pa\u00eds de Nunca Jam\u00e1s ","ShortTitle":"dj_jpir_temp1_ep26","LongDescription":"En este episodio, tus personajes favoritos te atrapar\u00e1n una vez m\u00e1s. No dejes de verlo. ","PropertyName":"jake and the never land pirates","PropertyCode":"jnp","LocalPropertyName":"Jake y los piratas del pa\u00eds de Nunca Jam\u00e1s ","SiteSection":"tv-djr","ContentType":"full episode","AgeConsent":"No Age Consent","thumbnail_updatedAt":"1385928609"},"id":"529b9dc0b99de10c2d000008","source":"kaltura","updated_at":"2013-12-17T12:10:25-08:00","video_id":"0_688mf11n"}],"embedURL":"http://videos.disneylatino.com/embed/4ec7f03ddd75440b2f47e691","ptitle":"Jake y los piratas del Pa\u00eds de Nunca Jam\u00e1s","phref":"http://videos.disneylatino.com/jake-y-los-piratas-del-pa-s-de-nunca-jam-s","publish_date":"December 17, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"24:13","duration_sec":1453,"duration_iso":"T00H24M13S","badge":null,"primaryImageName":"thumb","id":"4ec7e2d549f1579b014122e6","slug":"episodio-38-el-gran-desfile-los-heroes-de-la-ciudad","href":"http://videos.disneylatino.com/watch/episodio-38-el-gran-desfile-los-heroes-de-la-ciudad-4ec7e2d549f1579b014122e6","title":"Episodio 38: El gran desfile - Los h\u00e9roes de la ciudad","thumb":"http://cdnvideo.dolimg.com/cdn_assets/633dd511e24fc8ad791c47b9a1cf5a98678c9e4e.jpg","description":"Disfruta de momentos emocionantes viendo este episodio completo.","vType":"Full Episode - TV","externals":[{"account":"1068292","created_at":"2013-12-01T11:36:18-08:00","data":{"objectType":"KalturaMediaEntry","mediaType":"1","conversionQuality":"3945191","sourceType":"1","searchProviderType":null,"searchProviderId":null,"creditUserName":null,"creditUrl":null,"mediaDate":null,"dataUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/flvclipper/entry_id/0_a6m6kyud/version/0","flavorParamsIds":"0,301991,487111,525091,525101,525111,525121,525131,525141","plays":"0","views":"0","width":"720","height":"480","duration":"1453","msDuration":"1453000","durationType":null,"id":"0_a6m6kyud","name":"Episodio 38: El gran desfile - Los h\u00e9roes de la ciudad","description":"Disfruta de momentos emocionantes viendo este episodio completo.","partnerId":"1068292","userId":"cperales","creatorId":"cperales","tags":null,"adminTags":null,"categories":null,"categoriesIds":null,"status":"2","moderationStatus":"6","moderationCount":"0","type":"1","createdAt":"1385925224","updatedAt":"1387214985","rank":"0","totalRank":"0","votes":"0","groupId":null,"partnerData":null,"downloadUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/raw/entry_id/0_a6m6kyud/version/0","searchText":"_KAL_NET_ _1068292_ _MEDIA_TYPE_1|  Episodio 38: El gran desfile - Los h\u00e9roes de la ciudad Disfruta de momentos emocionantes viendo este episodio completo. ","licenseType":null,"version":"0","thumbnailUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/thumbnail/entry_id/0_a6m6kyud/version/100000","accessControlId":"1218511","startDate":null,"endDate":null,"referenceId":null,"replacingEntryId":null,"replacedEntryId":null,"replacementStatus":"0","partnerSortValue":"0","conversionProfileId":"3945191","rootEntryId":"0_a6m6kyud","operationAttributes":null,"entitledUsersEdit":null,"entitledUsersPublish":null,"Locale":"es_419","LongName":"Episodio 38: El gran desfile - Los h\u00e9roes de la ciudad","ShortTitle":"dj_hh_temp1_ep38","LongDescription":"Disfruta de momentos emocionantes viendo este episodio completo.","PropertyName":"higglytown heroes","PropertyCode":"hig","LocalPropertyName":"Los h\u00e9roes de la ciudad","SiteSection":"tv-djr","ContentType":"full episode","AgeConsent":"No Age Consent","thumbnail_updatedAt":"1385925233"},"id":"529b8fb1c697a15a86000014","source":"kaltura","updated_at":"2013-12-17T12:07:17-08:00","video_id":"0_a6m6kyud"}],"embedURL":"http://videos.disneylatino.com/embed/4ec7e2d549f1579b014122e6","publish_date":"December 17, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"24:13","duration_sec":1453,"duration_iso":"T00H24M13S","badge":null,"primaryImageName":"thumb","id":"4ec7e2d37752a79b014122e6","slug":"episodio-37-el-rescate-del-cohete-los-heroes-de-la-ciudad","href":"http://videos.disneylatino.com/watch/episodio-37-el-rescate-del-cohete-los-heroes-de-la-ciudad-4ec7e2d37752a79b014122e6","title":"Episodio 37: El rescate del cohete - Los h\u00e9roes de la ciudad","thumb":"http://cdnvideo.dolimg.com/cdn_assets/dc7dffb90327bedc2e216d2bd2a2be8f9dd7d8ee.jpg","description":"Mira este epsiodio de una de tus series favoritas, con los personajes que m\u00e1s te gustan y las historias que no olvidar\u00e1s.","vType":"Full Episode - TV","externals":[{"account":"1068292","created_at":"2013-12-01T11:36:16-08:00","data":{"objectType":"KalturaMediaEntry","mediaType":"1","conversionQuality":"3945191","sourceType":"1","searchProviderType":null,"searchProviderId":null,"creditUserName":null,"creditUrl":null,"mediaDate":null,"dataUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/flvclipper/entry_id/0_5pu5f2l8/version/0","flavorParamsIds":"0,301991,487111,525091,525101,525111,525121,525131,525141","plays":"0","views":"0","width":"720","height":"480","duration":"1453","msDuration":"1453000","durationType":null,"id":"0_5pu5f2l8","name":"Episodio 37: El rescate del cohete - Los h\u00e9roes de la ciudad","description":"Mira este epsiodio de una de tus series favoritas, con los personajes que m\u00e1s te gustan y las historias que no olvidar\u00e1s. ","partnerId":"1068292","userId":"cperales","creatorId":"cperales","tags":null,"adminTags":null,"categories":null,"categoriesIds":null,"status":"2","moderationStatus":"6","moderationCount":"0","type":"1","createdAt":"1385923396","updatedAt":"1387214978","rank":"0","totalRank":"0","votes":"0","groupId":null,"partnerData":null,"downloadUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/raw/entry_id/0_5pu5f2l8/version/0","searchText":"_KAL_NET_ _1068292_ _MEDIA_TYPE_1|  Episodio 37: El rescate del cohete - Los h\u00e9roes de la ciudad Mira este epsiodio de una de tus series favoritas, con los personajes que m\u00e1s te gustan y las historias que no olvidar\u00e1s. ","licenseType":null,"version":"0","thumbnailUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/thumbnail/entry_id/0_5pu5f2l8/version/100000","accessControlId":"1218511","startDate":null,"endDate":null,"referenceId":null,"replacingEntryId":null,"replacedEntryId":null,"replacementStatus":"0","partnerSortValue":"0","conversionProfileId":"3945191","rootEntryId":"0_5pu5f2l8","operationAttributes":null,"entitledUsersEdit":null,"entitledUsersPublish":null,"Locale":"es_419","LongName":"Episodio 37: El rescate del cohete - Los h\u00e9roes de la ciudad","ShortTitle":"dj_hh_temp1_ep37","LongDescription":"Mira este epsiodio de una de tus series favoritas, con los personajes que m\u00e1s te gustan y las historias que no olvidar\u00e1s. ","PropertyName":"higglytown heroes","PropertyCode":"hig","LocalPropertyName":"Los h\u00e9roes de la ciudad","SiteSection":"tv-djr","ContentType":"full episode","AgeConsent":"No Age Consent","thumbnail_updatedAt":"1385923409"},"id":"529b8fafc697a15a86000005","source":"kaltura","updated_at":"2013-12-17T12:01:09-08:00","video_id":"0_5pu5f2l8"}],"embedURL":"http://videos.disneylatino.com/embed/4ec7e2d37752a79b014122e6","publish_date":"December 17, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"24:20","duration_sec":1460,"duration_iso":"T00H24M20S","badge":null,"primaryImageName":"thumb","id":"4ec7347a447541400186edcb","slug":"episodio-1-el-mundo-bajo-nuestros-pies-primera-parte-bajoterra","href":"http://videos.disneylatino.com/watch/episodio-1-el-mundo-bajo-nuestros-pies-primera-parte-bajoterra-4ec7347a447541400186edcb","title":"Episodio 1: El mundo bajo nuestros pies primera parte - Bajoterra","thumb":"http://cdnvideo.dolimg.com/cdn_assets/a31156c30d3e94797acdcceb3969b880a934a556.jpg","description":"Este episodio es tan divertido que no podr\u00e1s dejar de verlo hasta el final.","vType":"Full Episode - TV","externals":[{"account":"1068292","created_at":"2013-11-30T22:36:14-08:00","data":{"objectType":"KalturaMediaEntry","mediaType":"1","conversionQuality":"3945191","sourceType":"1","searchProviderType":null,"searchProviderId":null,"creditUserName":null,"creditUrl":null,"mediaDate":null,"dataUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/flvclipper/entry_id/0_9mrgaqbz/version/0","flavorParamsIds":"0,301991,487111,525091,525101,525111,525121,525131,525141","plays":"0","views":"0","width":"1920","height":"1072","duration":"1460","msDuration":"1460000","durationType":null,"id":"0_9mrgaqbz","name":"Episodio 1: El mundo bajo nuestros pies primera parte - Bajoterra","description":"Este episodio es tan divertido que no podr\u00e1s dejar de verlo hasta el final.","partnerId":"1068292","userId":"cperales","creatorId":"cperales","tags":null,"adminTags":null,"categories":null,"categoriesIds":null,"status":"2","moderationStatus":"6","moderationCount":"0","type":"1","createdAt":"1385878800","updatedAt":"1387216412","rank":"0","totalRank":"0","votes":"0","groupId":null,"partnerData":null,"downloadUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/raw/entry_id/0_9mrgaqbz/version/0","searchText":"_KAL_NET_ _1068292_ _MEDIA_TYPE_1|  Episodio 1: El mundo bajo nuestros pies primera parte - Bajoterra Este episodio es tan divertido que no podr\u00e1s dejar de verlo hasta el final. ","licenseType":null,"version":"0","thumbnailUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/thumbnail/entry_id/0_9mrgaqbz/version/100000","accessControlId":"1218511","startDate":null,"endDate":null,"referenceId":null,"replacingEntryId":null,"replacedEntryId":null,"replacementStatus":"0","partnerSortValue":"0","conversionProfileId":"3945191","rootEntryId":"0_9mrgaqbz","operationAttributes":null,"entitledUsersEdit":null,"entitledUsersPublish":null,"Locale":"es_419","LongName":"Episodio 1: El mundo bajo nuestros pies primera parte - Bajoterra","ShortTitle":"dxd_slugterra_temp1_ep1","LongDescription":"Este episodio es tan divertido que no podr\u00e1s dejar de verlo hasta el final.","PropertyName":"slugterra","PropertyCode":"slug","LocalPropertyName":"Bajoterra","SiteSection":"tv-dxd","ContentType":"full episode","AgeConsent":"No Age Consent","thumbnail_updatedAt":"1385878816"},"id":"529ad8deb99de172c1000002","source":"kaltura","updated_at":"2013-12-17T09:39:36-08:00","video_id":"0_9mrgaqbz"}],"embedURL":"http://videos.disneylatino.com/embed/4ec7347a447541400186edcb","ptitle":"Bajoterra","phref":"http://videos.disneylatino.com/bajoterra","publish_date":"December 17, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"22:58","duration_sec":1378,"duration_iso":"T00H22M58S","badge":null,"primaryImageName":"thumb","id":"4ec6c9302e455f93407b9fa1","slug":"episodio-35-el-coach-peter-punk","href":"http://videos.disneylatino.com/watch/episodio-35-el-coach-peter-punk-4ec6c9302e455f93407b9fa1","title":"Episodio 35: El coach - Peter Punk","thumb":"http://cdnvideo.dolimg.com/cdn_assets/c4bbf337771a13f6b53c51926140fde7890515a4.jpg","description":"Tus personajes favoritos hacen de las suyas en este episodio completo.","vType":"Full Episode - TV","externals":[{"account":"1068292","created_at":"2013-11-30T14:36:15-08:00","data":{"objectType":"KalturaMediaEntry","mediaType":"1","conversionQuality":"3945191","sourceType":"1","searchProviderType":null,"searchProviderId":null,"creditUserName":null,"creditUrl":null,"mediaDate":null,"dataUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/flvclipper/entry_id/0_v6vho0v8/version/0","flavorParamsIds":"0,301991,487111,525091,525101,525111,525121,525131,525141","plays":"0","views":"0","width":"1920","height":"1072","duration":"1378","msDuration":"1378000","durationType":null,"id":"0_v6vho0v8","name":"Episodio 35: El coach - Peter Punk","description":"Tus personajes favoritos hacen de las suyas en este episodio completo.","partnerId":"1068292","userId":"cperales","creatorId":"cperales","tags":null,"adminTags":null,"categories":null,"categoriesIds":null,"status":"2","moderationStatus":"6","moderationCount":"0","type":"1","createdAt":"1385848713","updatedAt":"1387216492","rank":"0","totalRank":"0","votes":"0","groupId":null,"partnerData":null,"downloadUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/raw/entry_id/0_v6vho0v8/version/0","searchText":"_KAL_NET_ _1068292_ _MEDIA_TYPE_1|  Episodio 35: El coach - Peter Punk Tus personajes favoritos hacen de las suyas en este episodio completo. ","licenseType":null,"version":"0","thumbnailUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/thumbnail/entry_id/0_v6vho0v8/version/100000","accessControlId":"1218511","startDate":null,"endDate":null,"referenceId":null,"replacingEntryId":null,"replacedEntryId":null,"replacementStatus":"0","partnerSortValue":"0","conversionProfileId":"3945191","rootEntryId":"0_v6vho0v8","operationAttributes":null,"entitledUsersEdit":null,"entitledUsersPublish":null,"Locale":"es_419","LongName":"Episodio 35: El coach - Peter Punk","ShortTitle":"dxd_ppunk_temp1_ep35","LongDescription":"Tus personajes favoritos hacen de las suyas en este episodio completo.","PropertyName":"peter punk","PropertyCode":"ppk","LocalPropertyName":"Peter Punk","SiteSection":"tv-dxd","ContentType":"full episode","AgeConsent":"No Age Consent","thumbnail_updatedAt":"1385848724"},"id":"529a685d38b2bc7ae9000002","source":"kaltura","updated_at":"2013-12-17T06:17:00-08:00","video_id":"0_v6vho0v8"}],"embedURL":"http://videos.disneylatino.com/embed/4ec6c9302e455f93407b9fa1","ptitle":"Peter Punk","phref":"http://videos.disneylatino.com/peter-punk","publish_date":"December 17, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"22:02","duration_sec":1322,"duration_iso":"T00H22M02S","badge":null,"primaryImageName":"thumb","id":"4ec6d699cf7148806bd0a113","slug":"episodio-25-cena-para-squonks-par-de-reyes","href":"http://videos.disneylatino.com/watch/episodio-25-cena-para-squonks-par-de-reyes-4ec6d699cf7148806bd0a113","title":"Episodio 25: Cena para Squonks - Par de Reyes","thumb":"http://cdnvideo.dolimg.com/cdn_assets/8b0ea35f5472efb6aa3088a5c16a298ae70ed6b2.jpg","description":"Este episodio incluye risas, enredos y emoci\u00f3n. \u00bfTe lo vas a perder?","vType":"Full Episode - TV","externals":[{"account":"1068292","created_at":"2013-11-30T15:36:15-08:00","data":{"objectType":"KalturaMediaEntry","mediaType":"1","conversionQuality":"3945191","sourceType":"1","searchProviderType":null,"searchProviderId":null,"creditUserName":null,"creditUrl":null,"mediaDate":null,"dataUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/flvclipper/entry_id/0_b3l3sum3/version/0","flavorParamsIds":"0,301991,487111,525091,525101,525111,525121,525131,525141","plays":"0","views":"0","width":"1920","height":"1072","duration":"1322","msDuration":"1322000","durationType":null,"id":"0_b3l3sum3","name":"Episodio 25: Cena para Squonks - Par de Reyes","description":"Este episodio incluye risas, enredos y emoci\u00f3n. \u00bfTe lo vas a perder?","partnerId":"1068292","userId":"cperales","creatorId":"cperales","tags":null,"adminTags":null,"categories":null,"categoriesIds":null,"status":"2","moderationStatus":"6","moderationCount":"0","type":"1","createdAt":"1385853074","updatedAt":"1387216293","rank":"0","totalRank":"0","votes":"0","groupId":null,"partnerData":null,"downloadUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/raw/entry_id/0_b3l3sum3/version/0","searchText":"_KAL_NET_ _1068292_ _MEDIA_TYPE_1|  Episodio 25: Cena para Squonks - Par de Reyes Este episodio incluye risas, enredos y emoci\u00f3n. \u00bfTe lo vas a perder? ","licenseType":null,"version":"0","thumbnailUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/thumbnail/entry_id/0_b3l3sum3/version/100000","accessControlId":"1218511","startDate":null,"endDate":null,"referenceId":null,"replacingEntryId":null,"replacedEntryId":null,"replacementStatus":"0","partnerSortValue":"0","conversionProfileId":"3945191","rootEntryId":"0_b3l3sum3","operationAttributes":null,"entitledUsersEdit":null,"entitledUsersPublish":null,"Locale":"es_419","LongName":"Episodio 25: Cena para Squonks - Par de Reyes","ShortTitle":"dxd_pok_temp3_ep25","LongDescription":"Este episodio incluye risas, enredos y emoci\u00f3n. \u00bfTe lo vas a perder?","PropertyName":"pair of kings","PropertyCode":"pok","LocalPropertyName":"Par de Reyes","SiteSection":"tv-dxd","ContentType":"full episode","AgeConsent":"No Age Consent","thumbnail_updatedAt":"1385853096"},"id":"529a766ec697a1268e000005","source":"kaltura","updated_at":"2013-12-17T06:12:21-08:00","video_id":"0_b3l3sum3"}],"embedURL":"http://videos.disneylatino.com/embed/4ec6d699cf7148806bd0a113","ptitle":"Par de Reyes","phref":"http://videos.disneylatino.com/par-de-reyes","publish_date":"December 17, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"23:00","duration_sec":1380,"duration_iso":"T00H23M00S","badge":null,"primaryImageName":"thumb","id":"4ec55f1ab8bba73dffe3f33a","slug":"episodio-32-la-novia-de-muji-pucca","href":"http://videos.disneylatino.com/watch/episodio-32-la-novia-de-muji-pucca-4ec55f1ab8bba73dffe3f33a","title":"Episodio 32: La novia de Muji - Pucca","thumb":"http://cdnvideo.dolimg.com/cdn_assets/f12ea3d2ed2817afcd4f6f060c7443bf8c8041e9.jpg","description":"Disfruta de este episodio de una de tus series favoritas.","vType":"Full Episode - TV","externals":[{"account":"1068292","created_at":"2013-11-29T11:36:18-08:00","data":{"objectType":"KalturaMediaEntry","mediaType":"1","conversionQuality":"3945191","sourceType":"1","searchProviderType":null,"searchProviderId":null,"creditUserName":null,"creditUrl":null,"mediaDate":null,"dataUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/flvclipper/entry_id/0_lvycz621/version/0","flavorParamsIds":"0,301991,487111,525091,525101,525111,525121,525131,525141","plays":"0","views":"0","width":"720","height":"480","duration":"1380","msDuration":"1380000","durationType":null,"id":"0_lvycz621","name":"Episodio 32: La novia de Muji - Pucca","description":"Disfruta de este episodio de una de tus series favoritas.","partnerId":"1068292","userId":"cperales","creatorId":"cperales","tags":null,"adminTags":null,"categories":null,"categoriesIds":null,"status":"2","moderationStatus":"6","moderationCount":"0","type":"1","createdAt":"1385750499","updatedAt":"1387221875","rank":"0","totalRank":"0","votes":"0","groupId":null,"partnerData":null,"downloadUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/raw/entry_id/0_lvycz621/version/0","searchText":"_KAL_NET_ _1068292_ _MEDIA_TYPE_1|  Episodio 32: La novia de Muji - Pucca Disfruta de este episodio de una de tus series favoritas. ","licenseType":null,"version":"0","thumbnailUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/thumbnail/entry_id/0_lvycz621/version/100000","accessControlId":"1218511","startDate":null,"endDate":null,"referenceId":null,"replacingEntryId":null,"replacedEntryId":null,"replacementStatus":"0","partnerSortValue":"0","conversionProfileId":"3945191","rootEntryId":"0_lvycz621","operationAttributes":null,"entitledUsersEdit":null,"entitledUsersPublish":null,"thumbnail_updatedAt":"1385750513","Locale":"es_419","LongName":"Episodio 32: La novia de Muji - Pucca","ShortTitle":"dxd_pucca_temp1_ep32","LongDescription":"Disfruta de este episodio de una de tus series favoritas.","PropertyName":"pucca","PropertyCode":"puc","LocalPropertyName":"Pucca","SiteSection":"tv-dxd","ContentType":"full episode","AgeConsent":"No Age Consent"},"id":"5298ecb138b2bc419000000b","source":"kaltura","updated_at":"2013-12-17T05:54:12-08:00","video_id":"0_lvycz621"}],"embedURL":"http://videos.disneylatino.com/embed/4ec55f1ab8bba73dffe3f33a","ptitle":"Pucca","phref":"http://videos.disneylatino.com/pucca","publish_date":"December 17, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"23:00","duration_sec":1380,"duration_iso":"T00H23M00S","badge":null,"primaryImageName":"thumb","id":"4ec5444bd16e18b1f66e6be6","slug":"episodio-31-amor-imborrable-pucca","href":"http://videos.disneylatino.com/watch/episodio-31-amor-imborrable-pucca-4ec5444bd16e18b1f66e6be6","title":"Episodio 31: Amor imborrable - Pucca","thumb":"http://cdnvideo.dolimg.com/cdn_assets/1e664334d8bd2799063da7f19b291755d2c4c400.jpg","description":"Este episodio est\u00e1 lleno de momentos memorables. \u00a1Disfr\u00fatalo!","vType":"Full Episode - TV","externals":[{"account":"1068292","created_at":"2013-11-29T09:36:22-08:00","data":{"objectType":"KalturaMediaEntry","mediaType":"1","conversionQuality":"3945191","sourceType":"1","searchProviderType":null,"searchProviderId":null,"creditUserName":null,"creditUrl":null,"mediaDate":null,"dataUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/flvclipper/entry_id/0_1hq50tcb/version/0","flavorParamsIds":"0,301991,487111,525091,525101,525111,525121,525131,525141","plays":"0","views":"0","width":"720","height":"480","duration":"1380","msDuration":"1380000","durationType":null,"id":"0_1hq50tcb","name":"Episodio 31: Amor imborrable - Pucca","description":"Este episodio est\u00e1 lleno de momentos memorables. \u00a1Disfr\u00fatalo!","partnerId":"1068292","userId":"cperales","creatorId":"cperales","tags":null,"adminTags":null,"categories":null,"categoriesIds":null,"status":"2","moderationStatus":"6","moderationCount":"0","type":"1","createdAt":"1385745778","updatedAt":"1387221851","rank":"0","totalRank":"0","votes":"0","groupId":null,"partnerData":null,"downloadUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/raw/entry_id/0_1hq50tcb/version/0","searchText":"_KAL_NET_ _1068292_ _MEDIA_TYPE_1|  Episodio 31: Amor imborrable - Pucca Este episodio est\u00e1 lleno de momentos memorables. \u00a1Disfr\u00fatalo! ","licenseType":null,"version":"0","thumbnailUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/thumbnail/entry_id/0_1hq50tcb/version/100000","accessControlId":"1218511","startDate":null,"endDate":null,"referenceId":null,"replacingEntryId":null,"replacedEntryId":null,"replacementStatus":"0","partnerSortValue":"0","conversionProfileId":"3945191","rootEntryId":"0_1hq50tcb","operationAttributes":null,"entitledUsersEdit":null,"entitledUsersPublish":null,"thumbnail_updatedAt":"1385745790","Locale":"es_419","LongName":"Episodio 31: Amor imborrable - Pucca","ShortTitle":"dxd_pucca_temp1_ep31","LongDescription":"Este episodio est\u00e1 lleno de momentos memorables. \u00a1Disfr\u00fatalo!","PropertyName":"pucca","PropertyCode":"puc","LocalPropertyName":"Pucca","SiteSection":"tv-dxd","ContentType":"full episode","AgeConsent":"No Age Consent"},"id":"5298d095c697a114e700001d","source":"kaltura","updated_at":"2013-12-17T05:50:43-08:00","video_id":"0_1hq50tcb"}],"embedURL":"http://videos.disneylatino.com/embed/4ec5444bd16e18b1f66e6be6","ptitle":"Pucca","phref":"http://videos.disneylatino.com/pucca","publish_date":"December 17, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"22:57","duration_sec":1377,"duration_iso":"T00H22M57S","badge":null,"primaryImageName":"thumb","id":"4ec5444aa49538b1f66e6be6","slug":"episodio-30-palillos-en-peligro-pucca","href":"http://videos.disneylatino.com/watch/episodio-30-palillos-en-peligro-pucca-4ec5444aa49538b1f66e6be6","title":"Episodio 30: Palillos en peligro - Pucca","thumb":"http://cdnvideo.dolimg.com/cdn_assets/a83eeb3ecebf085c8991b1d9e3247f32da261cc8.jpg","description":"Revive tus momentos favoritos de este episodio.","vType":"Full Episode - TV","externals":[{"account":"1068292","created_at":"2013-11-29T09:36:20-08:00","data":{"objectType":"KalturaMediaEntry","mediaType":"1","conversionQuality":"3945191","sourceType":"1","searchProviderType":null,"searchProviderId":null,"creditUserName":null,"creditUrl":null,"mediaDate":null,"dataUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/flvclipper/entry_id/0_cw5n2v6v/version/0","flavorParamsIds":"0,301991,487111,525091,525101,525111,525121,525131,525141","plays":"0","views":"0","width":"720","height":"480","duration":"1377","msDuration":"1377000","durationType":null,"id":"0_cw5n2v6v","name":"Episodio 30: Palillos en peligro - Pucca","description":"Revive tus momentos favoritos de este episodio.","partnerId":"1068292","userId":"cperales","creatorId":"cperales","tags":null,"adminTags":null,"categories":null,"categoriesIds":null,"status":"2","moderationStatus":"6","moderationCount":"0","type":"1","createdAt":"1385743956","updatedAt":"1387221869","rank":"0","totalRank":"0","votes":"0","groupId":null,"partnerData":null,"downloadUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/raw/entry_id/0_cw5n2v6v/version/0","searchText":"_KAL_NET_ _1068292_ _MEDIA_TYPE_1|  Episodio 30: Palillos en peligro - Pucca Revive tus momentos favoritos de este episodio. ","licenseType":null,"version":"0","thumbnailUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/thumbnail/entry_id/0_cw5n2v6v/version/100000","accessControlId":"1218511","startDate":null,"endDate":null,"referenceId":null,"replacingEntryId":null,"replacedEntryId":null,"replacementStatus":"0","partnerSortValue":"0","conversionProfileId":"3945191","rootEntryId":"0_cw5n2v6v","operationAttributes":null,"entitledUsersEdit":null,"entitledUsersPublish":null,"thumbnail_updatedAt":"1385743965","Locale":"es_419","LongName":"Episodio 30: Palillos en peligro - Pucca","ShortTitle":"dxd_pucca_temp1_ep30","LongDescription":"Revive tus momentos favoritos de este episodio.","PropertyName":"pucca","PropertyCode":"puc","LocalPropertyName":"Pucca","SiteSection":"tv-dxd","ContentType":"full episode","AgeConsent":"No Age Consent"},"id":"5298d094c697a114e7000011","source":"kaltura","updated_at":"2013-12-17T05:47:17-08:00","video_id":"0_cw5n2v6v"}],"embedURL":"http://videos.disneylatino.com/embed/4ec5444aa49538b1f66e6be6","ptitle":"Pucca","phref":"http://videos.disneylatino.com/pucca","publish_date":"December 17, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"}],"suggested":[{"duration":"25:30","duration_sec":1530,"duration_iso":"T00H25M30S","badge":null,"primaryImageName":"thumb","id":"4ec55f1bfb63c73dffe3f33a","slug":"episodio-45-planeta-hulk-el-escuadron-de-superheroes","href":"http://videos.disneylatino.com/watch/episodio-45-planeta-hulk-el-escuadron-de-superheroes-4ec55f1bfb63c73dffe3f33a","title":"Episodio 45: Planeta Hulk - El escuadr\u00f3n de superh\u00e9roes","thumb":"http://cdnvideo.dolimg.com/cdn_assets/caca6a38234347b4e82d17503aeefba0e3321c03.jpg","description":"Si a\u00fan no has visto este episodio, haz click y disfr\u00fatalo ahora porque es imperdible.","vType":"Full Episode - TV","externals":[{"account":"1068292","created_at":"2013-11-29T11:36:20-08:00","data":{"objectType":"KalturaMediaEntry","mediaType":"1","conversionQuality":"3945191","sourceType":"1","searchProviderType":null,"searchProviderId":null,"creditUserName":null,"creditUrl":null,"mediaDate":null,"dataUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/flvclipper/entry_id/0_nqrg51k8/version/0","flavorParamsIds":"0,301991,487111,525091,525101,525111,525121,525131,525141","plays":"0","views":"0","width":"720","height":"480","duration":"1530","msDuration":"1530000","durationType":null,"id":"0_nqrg51k8","name":"Episodio 45: Planeta Hulk - El escuadr\u00f3n de superh\u00e9roes","description":"Si a\u00fan no has visto este episodio, haz click y disfr\u00fatalo ahora porque es imperdible.","partnerId":"1068292","userId":"cperales","creatorId":"cperales","tags":null,"adminTags":null,"categories":null,"categoriesIds":null,"status":"2","moderationStatus":"6","moderationCount":"0","type":"1","createdAt":"1385752471","updatedAt":"1387221616","rank":"0","totalRank":"0","votes":"0","groupId":null,"partnerData":null,"downloadUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/raw/entry_id/0_nqrg51k8/version/0","searchText":"_KAL_NET_ _1068292_ _MEDIA_TYPE_1|  Episodio 45: Planeta Hulk - El escuadr\u00f3n de superh\u00e9roes Si a\u00fan no has visto este episodio, haz click y disfr\u00fatalo ahora porque es imperdible. ","licenseType":null,"version":"0","thumbnailUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/thumbnail/entry_id/0_nqrg51k8/version/100000","accessControlId":"1218511","startDate":null,"endDate":null,"referenceId":null,"replacingEntryId":null,"replacedEntryId":null,"replacementStatus":"0","partnerSortValue":"0","conversionProfileId":"3945191","rootEntryId":"0_nqrg51k8","operationAttributes":null,"entitledUsersEdit":null,"entitledUsersPublish":null,"thumbnail_updatedAt":"1385752480","Locale":"es_419","LongName":"Episodio 45: Planeta Hulk - El escuadr\u00f3n de superh\u00e9roes","ShortTitle":"dxd_shs_temp2_ep45","LongDescription":"Si a\u00fan no has visto este episodio, haz click y disfr\u00fatalo ahora porque es imperdible.","PropertyName":"the super hero squad show","PropertyCode":"ssqs","LocalPropertyName":"El escuadr\u00f3n de superh\u00e9roes","SiteSection":"tv-dxd","ContentType":"full episode","AgeConsent":"No Age Consent"},"id":"5298ecb338b2bc4190000017","source":"kaltura","updated_at":"2013-12-17T05:35:09-08:00","video_id":"0_nqrg51k8"}],"embedURL":"http://videos.disneylatino.com/embed/4ec55f1bfb63c73dffe3f33a","ptitle":"El escuadr\u00f3n de superh\u00e9roes","phref":"http://videos.disneylatino.com/el-escuadr-n-de-superh-roes","publish_date":"December 17, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"22:48","duration_sec":1368,"duration_iso":"T00H22M48S","badge":null,"primaryImageName":"thumb","id":"4ec5af930806378902068d2f","slug":"episodio-11-no-hables-con-extranos-bondi-band","href":"http://videos.disneylatino.com/watch/episodio-11-no-hables-con-extranos-bondi-band-4ec5af930806378902068d2f","title":"Episodio 11: No hables con extra\u00f1os - Bondi Band","thumb":"http://cdnvideo.dolimg.com/cdn_assets/71cbacbd1a88e033df3294f8d1a132e08bf537ac.jpg","description":"Tus personajes favoritos hacen de las suyas en este episodio completo.","vType":"Full Episode - TV","externals":[{"account":"1068292","created_at":"2013-11-29T17:36:19-08:00","data":{"objectType":"KalturaMediaEntry","mediaType":"1","conversionQuality":"3945191","sourceType":"1","searchProviderType":null,"searchProviderId":null,"creditUserName":null,"creditUrl":null,"mediaDate":null,"dataUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/flvclipper/entry_id/0_yj180rks/version/0","flavorParamsIds":"0,301991,487111,525091,525101,525111,525121,525131,525141","plays":"0","views":"0","width":"720","height":"480","duration":"1368","msDuration":"1368000","durationType":null,"id":"0_yj180rks","name":"Episodio 11: No hables con extra\u00f1os - Bondi Band","description":"Tus personajes favoritos hacen de las suyas en este episodio completo.","partnerId":"1068292","userId":"cperales","creatorId":"cperales","tags":null,"adminTags":null,"categories":null,"categoriesIds":null,"status":"2","moderationStatus":"6","moderationCount":"0","type":"1","createdAt":"1385771728","updatedAt":"1387217941","rank":"0","totalRank":"0","votes":"0","groupId":null,"partnerData":null,"downloadUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/raw/entry_id/0_yj180rks/version/0","searchText":"_KAL_NET_ _1068292_ _MEDIA_TYPE_1|  Episodio 11: No hables con extra\u00f1os - Bondi Band Tus personajes favoritos hacen de las suyas en este episodio completo. ","licenseType":null,"version":"0","thumbnailUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/thumbnail/entry_id/0_yj180rks/version/100000","accessControlId":"1218511","startDate":null,"endDate":null,"referenceId":null,"replacingEntryId":null,"replacedEntryId":null,"replacementStatus":"0","partnerSortValue":"0","conversionProfileId":"3945191","rootEntryId":"0_yj180rks","operationAttributes":null,"entitledUsersEdit":null,"entitledUsersPublish":null,"Locale":"es_419","LongName":"Episodio 11: No hables con extra\u00f1os - Bondi Band","ShortTitle":"dxd_bondi_temp1_ep11","LongDescription":"Tus personajes favoritos hacen de las suyas en este episodio completo.","PropertyName":"college road trip","PropertyCode":"crt","LocalPropertyName":"Bondi Band","SiteSection":"tv-dxd","ContentType":"full episode","AgeConsent":"No Age Consent","thumbnail_updatedAt":"1385771742"},"id":"5299411238b2bc3615000008","source":"kaltura","updated_at":"2013-12-17T05:23:57-08:00","video_id":"0_yj180rks"}],"embedURL":"http://videos.disneylatino.com/embed/4ec5af930806378902068d2f","ptitle":"Bondi Band","phref":"http://videos.disneylatino.com/bondi-band","publish_date":"December 17, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"22:19","duration_sec":1339,"duration_iso":"T00H22M19S","badge":null,"primaryImageName":"thumb","id":"4ec5a22ae4d55b6b4b19fbbf","slug":"episodio-10-el-triunfo-de-miss-c-lebrity-bondi-band","href":"http://videos.disneylatino.com/watch/episodio-10-el-triunfo-de-miss-c-lebrity-bondi-band-4ec5a22ae4d55b6b4b19fbbf","title":"Episodio 10: El triunfo de Miss C. Lebrity - Bondi Band","thumb":"http://cdnvideo.dolimg.com/cdn_assets/43f6183a0509d69e986695df47d71a113b9f1f90.jpg","description":"\u00a1El disfrute est\u00e1 garantizado con este episodio! M\u00edralo.","vType":"Full Episode - TV","externals":[{"account":"1068292","created_at":"2013-11-29T16:36:20-08:00","data":{"objectType":"KalturaMediaEntry","mediaType":"1","conversionQuality":"3945191","sourceType":"1","searchProviderType":null,"searchProviderId":null,"creditUserName":null,"creditUrl":null,"mediaDate":null,"dataUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/flvclipper/entry_id/0_njukan5z/version/0","flavorParamsIds":"0,301991,487111,525091,525101,525111,525121,525131,525141","plays":"0","views":"0","width":"528","height":"352","duration":"1339","msDuration":"1339000","durationType":null,"id":"0_njukan5z","name":"Episodio 10: El triunfo de Miss C. Lebrity - Bondi Band","description":"\u00a1El disfrute est\u00e1 garantizado con este episodio! M\u00edralo. ","partnerId":"1068292","userId":"cperales","creatorId":"cperales","tags":null,"adminTags":null,"categories":null,"categoriesIds":null,"status":"2","moderationStatus":"6","moderationCount":"0","type":"1","createdAt":"1385770326","updatedAt":"1387217929","rank":"0","totalRank":"0","votes":"0","groupId":null,"partnerData":null,"downloadUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/raw/entry_id/0_njukan5z/version/0","searchText":"_KAL_NET_ _1068292_ _MEDIA_TYPE_1|  Episodio 10: El triunfo de Miss C. Lebrity - Bondi Band \u00a1El disfrute est\u00e1 garantizado con este episodio! M\u00edralo. ","licenseType":null,"version":"0","thumbnailUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/thumbnail/entry_id/0_njukan5z/version/100000","accessControlId":"1218511","startDate":null,"endDate":null,"referenceId":null,"replacingEntryId":null,"replacedEntryId":null,"replacementStatus":"0","partnerSortValue":"0","conversionProfileId":"3945191","rootEntryId":"0_njukan5z","operationAttributes":null,"entitledUsersEdit":null,"entitledUsersPublish":null,"Locale":"es_419","LongName":"Episodio 10: El triunfo de Miss C. Lebrity - Bondi Band","ShortTitle":"dxd_bondi_temp1_ep10","LongDescription":"\u00a1El disfrute est\u00e1 garantizado con este episodio! M\u00edralo. ","PropertyName":"college road trip","PropertyCode":"crt","LocalPropertyName":"Bondi Band","SiteSection":"tv-dxd","ContentType":"full episode","AgeConsent":"No Age Consent","thumbnail_updatedAt":"1385770336"},"id":"52993303b99de11de7000014","source":"kaltura","updated_at":"2013-12-17T05:20:53-08:00","video_id":"0_njukan5z"}],"embedURL":"http://videos.disneylatino.com/embed/4ec5a22ae4d55b6b4b19fbbf","ptitle":"Bondi Band","phref":"http://videos.disneylatino.com/bondi-band","publish_date":"December 17, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"27:39","duration_sec":1659,"duration_iso":"T00H27M39S","badge":null,"primaryImageName":"thumb","id":"4ec5bcfafaf79ec7aad24198","slug":"episodio-7-pasado-por-agua-doctora-juguetes","href":"http://videos.disneylatino.com/watch/episodio-7-pasado-por-agua-doctora-juguetes-4ec5bcfafaf79ec7aad24198","title":"Episodio 7: Pasado por agua - Doctora Juguetes","thumb":"http://cdnvideo.dolimg.com/cdn_assets/e3cb7f4bf4ade328be83d813a4805b9b9d11a5a9.jpg","description":"\u00bfNo has visto este episodio? Aqu\u00ed tienes una oportunidad de disfrutarlo completo.","vType":"Full Episode - TV","externals":[{"account":"1068292","created_at":"2013-11-29T18:36:17-08:00","data":{"objectType":"KalturaMediaEntry","mediaType":"1","conversionQuality":"3945191","sourceType":"1","searchProviderType":null,"searchProviderId":null,"creditUserName":null,"creditUrl":null,"mediaDate":null,"dataUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/flvclipper/entry_id/0_jy8mc4vn/version/0","flavorParamsIds":"0,301991,487111,525091,525101,525111,525121,525131,525141","plays":"0","views":"0","width":"1920","height":"1072","duration":"1659","msDuration":"1659000","durationType":null,"id":"0_jy8mc4vn","name":"Episodio 7: Pasado por agua - Doctora Juguetes","description":"\u00bfNo has visto este episodio? Aqu\u00ed tienes una oportunidad de disfrutarlo completo.","partnerId":"1068292","userId":"cperales","creatorId":"cperales","tags":null,"adminTags":null,"categories":null,"categoriesIds":null,"status":"2","moderationStatus":"6","moderationCount":"0","type":"1","createdAt":"1385776274","updatedAt":"1387217713","rank":"0","totalRank":"0","votes":"0","groupId":null,"partnerData":null,"downloadUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/raw/entry_id/0_jy8mc4vn/version/0","searchText":"_KAL_NET_ _1068292_ _MEDIA_TYPE_1|  Episodio 7: Pasado por agua - Doctora Juguetes \u00bfNo has visto este episodio? Aqu\u00ed tienes una oportunidad de disfrutarlo completo. ","licenseType":null,"version":"0","thumbnailUrl":"http://cdnbakmi.kaltura.com/p/1068292/sp/106829200/thumbnail/entry_id/0_jy8mc4vn/version/100000","accessControlId":"1218511","startDate":null,"endDate":null,"referenceId":null,"replacingEntryId":null,"replacedEntryId":null,"replacementStatus":"0","partnerSortValue":"0","conversionProfileId":"3945191","rootEntryId":"0_jy8mc4vn","operationAttributes":null,"entitledUsersEdit":null,"entitledUsersPublish":null,"Locale":"es_419","LongName":"Episodio 7: Pasado por agua - Doctora Juguetes","ShortTitle":"dj_docmc_temp1_ep7","LongDescription":"\u00bfNo has visto este episodio? Aqu\u00ed tienes una oportunidad de disfrutarlo completo.","PropertyName":"doc mcstuffins","PropertyCode":"dms","LocalPropertyName":"Doctora Juguetes","SiteSection":"tv-djr","ContentType":"full episode","AgeConsent":"No Age Consent","thumbnail_updatedAt":"1385776290"},"id":"52994f21c697a161fc000005","source":"kaltura","updated_at":"2013-12-17T05:15:25-08:00","video_id":"0_jy8mc4vn"}],"embedURL":"http://videos.disneylatino.com/embed/4ec5bcfafaf79ec7aad24198","ptitle":"Doctora Jueguetes","phref":"http://videos.disneylatino.com/doc-mcstuffins","publish_date":"December 17, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"}],"ptitle":"Phineas y Ferb","phref":"http://videos.disneylatino.com/phineas-y-ferb","publish_date":"November 6, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"}],"style":{"images":{}},"translations":{"see_all":"Ver todos","no_javascript":"\u00a1OH, NO! Parece que tienes deshabilitado JavaScript en tu navegador de internet. Por favor, habil\u00edtalo para poder ver videos en Disneylatino.com","video_expired":"Lo sentimos, este video no est\u00e1 disponible","replay":"Volver a ver","watch_on":"Ver en","dependencies_not_met":"\u00a1OH, NO! Parece que tu navegador de internet no est\u00e1 actualizado. Por favor actual\u00edzalo o actualiza tu versi\u00f3n de Adobe Flash","get_flash_player":"Instala Adobe Flash Player","embedding_disabled":"Lo sentimos, pero este video solo puede ser reproducido en Disneylatino.com","country_disallowed":"Lo sentimos, este video no puede ser reproducido en tu pa\u00eds","device_not_supported":"Lo sentimos, pero tu dispositivo no es compatible para reproducir este video","video_not_found":"\u00a1OH, NO! No podemos encontrar el video en este momento. Intenta nuevamente m\u00e1s tarde"},"see_all_text":"Ver todos"},{"view":"slider","ref":"1-2","type":"video","count":556,"title":"Disney Channel","data":[{"duration":"22:03","duration_sec":1323,"duration_iso":"T00H22M03S","badge":null,"primaryImageName":"thumb","id":"4e8418feef4b013e1da0aa5b","slug":"buena-suerte-charlie-episodio-60-cambio-de-vestidos","href":"http://videos.disneylatino.com/watch/buena-suerte-charlie-episodio-60-cambio-de-vestidos-4e8418feef4b013e1da0aa5b","title":"Episodio 60: Cambio de vestidos - \u00a1Buena suerte, Charlie!","thumb":"http://cdnvideo.dolimg.com/cdn_assets/2bc98d8126dc21f553ad1ccea2f5e720d8ce4987.jpg","description":"\u00bfYa disfrutaste de este episodio en TV? Ahora rev\u00edvelo completo aqu\u00ed.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e8418feef4b013e1da0aa5b","ptitle":"\u00a1Buena suerte, Charlie!","phref":"http://videos.disneylatino.com/buena-suerte-charlie","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"21:30","duration_sec":1290,"duration_iso":"T00H21M30S","badge":null,"primaryImageName":"thumb","id":"4e83adacce25f122bb6f06de","slug":"gravity-falls-episodio-2","href":"http://videos.disneylatino.com/watch/gravity-falls-episodio-2-4e83adacce25f122bb6f06de","title":"Episodio 2: La leyenda del monstruo del lago - Gravity Falls","thumb":"http://cdnvideo.dolimg.com/cdn_assets/3e0fe64ec10da23d5d3a7a70eec1341fea1c8d8c.jpg","description":"Este episodio es tan divertido que no podr\u00e1s dejar de verlo hasta el final.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e83adacce25f122bb6f06de","ptitle":"Gravity Falls: un verano de misterio","phref":"http://videos.disneylatino.com/gravity-falls-un-verano-de-misterio","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"23:18","duration_sec":1398,"duration_iso":"T00H23M18S","badge":null,"primaryImageName":"thumb","id":"4e87c3c1f96d0ec929e2419a","slug":"programa-de-talentos-episodio-25-patente-pendiente","href":"http://videos.disneylatino.com/watch/programa-de-talentos-episodio-25-patente-pendiente-4e87c3c1f96d0ec929e2419a","title":"Episodio 25: Patente pendiente - Programa de Talentos","thumb":"http://cdnvideo.dolimg.com/cdn_assets/087fd341ddb67391e7a48dde73a2f6c8bde37449.jpg","description":"Revive tus momentos favoritos de este episodio.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e87c3c1f96d0ec929e2419a","ptitle":"Programa de talentos","phref":"http://videos.disneylatino.com/programa-de-talentos","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"21:15","duration_sec":1275,"duration_iso":"T00H21M15S","badge":null,"primaryImageName":"thumb","id":"4e83e34f0cfde0b28cefd4d9","slug":"stan-el-perro-bloguero-episodio-1-la-llegada-de-stan","href":"http://videos.disneylatino.com/watch/stan-el-perro-bloguero-episodio-1-la-llegada-de-stan-4e83e34f0cfde0b28cefd4d9","title":"Episodio 1: La llegada de Stan - Stan, el perro bloguero","thumb":"http://cdnvideo.dolimg.com/cdn_assets/018559d225ed351864486a4d85b034e6ca7f3ba5.jpg","description":"Si a\u00fan no has visto este episodio, haz click y disfr\u00fatalo ahora porque es imperdible.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e83e34f0cfde0b28cefd4d9","ptitle":"Stan, el perro bloguero","phref":"http://videos.disneylatino.com/stan-el-perro-bloguero","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"1:35","duration_sec":95,"duration_iso":"T00H01M35S","badge":null,"primaryImageName":"thumb","id":"4e8cf3b22d11852564402b1c","slug":"phineas-y-ferb-un-ornitorrinco-me-controla","href":"http://videos.disneylatino.com/watch/phineas-y-ferb-un-ornitorrinco-me-controla-4e8cf3b22d11852564402b1c","title":"Un ornitorrinco me controla - Phineas y Ferb","thumb":"http://cdnvideo.dolimg.com/cdn_assets/96ce38253158afbff4b5bb8ea2e27cf5d0cbe0f2.jpg","description":"\u00a1Canta y baila esta canci\u00f3n de Phineas y Ferb!","vType":"Music Video","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e8cf3b22d11852564402b1c","ptitle":"Phineas y Ferb","phref":"http://videos.disneylatino.com/phineas-y-ferb","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"2:00","duration_sec":120,"duration_iso":"T00H02M00S","badge":null,"primaryImageName":"thumb","id":"4e8532fe82f9275d9ef0a06b","slug":"austin-and-ally-laura-marano-asi-soy-yo","href":"http://videos.disneylatino.com/watch/austin-and-ally-laura-marano-asi-soy-yo-4e8532fe82f9275d9ef0a06b","title":"Laura Marano: As\u00ed soy yo - Austin & Ally","thumb":"http://cdnvideo.dolimg.com/cdn_assets/57e2f99d5ff9e99caf7d108475ecf46637046111.jpg","description":"\u00bfQuieres conocer un poco m\u00e1s sobre Laura Marano? Mira este clip.","vType":"Clip","adPattern":"ACC","embedURL":"http://videos.disneylatino.com/embed/4e8532fe82f9275d9ef0a06b","ptitle":"Austin & Ally","phref":"http://videos.disneylatino.com/austin-and-ally","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"1:30","duration_sec":90,"duration_iso":"T00H01M30S","badge":null,"primaryImageName":"thumb","id":"4ed44001e88ff7d673076d45","slug":"software-deja-tu-marca","href":"http://videos.disneylatino.com/watch/software-deja-tu-marca-4ed44001e88ff7d673076d45","title":"Software - Deja tu Marca","thumb":"http://cdnvideo.dolimg.com/cdn_assets/a4eb886b35b7075ddb81a7c28a275dd888f26b6b.jpg","description":"Cuando se trata de influir positivamente en las vidas de las personas, cada aporte es importante. Este es un ejemplo conmovedor.","vType":"Clip","adPattern":"ACC","embedURL":"http://videos.disneylatino.com/embed/4ed44001e88ff7d673076d45","publish_date":"December 23, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"1:30","duration_sec":90,"duration_iso":"T00H01M30S","badge":null,"primaryImageName":"thumb","id":"4ed43feaf8ede7d673076d45","slug":"boutique-deja-tu-marca","href":"http://videos.disneylatino.com/watch/boutique-deja-tu-marca-4ed43feaf8ede7d673076d45","title":"Boutique - Deja tu Marca","thumb":"http://cdnvideo.dolimg.com/cdn_assets/69dd2eebcc56d84b5d14fb5325437c90974a6067.jpg","description":"Un ejemplo inspirador de c\u00f3mo todos podemos \"dejar nuestra marca\" en las vidas de los dem\u00e1s.","vType":"Clip","adPattern":"ACC","embedURL":"http://videos.disneylatino.com/embed/4ed43feaf8ede7d673076d45","publish_date":"December 23, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"12:17","duration_sec":737,"duration_iso":"T00H12M17S","badge":null,"primaryImageName":"thumb","id":"4ede5c2f8e257d1043ac4f2d","slug":"episodio-55-feliz-navipez-milo-pecezuelos","href":"http://videos.disneylatino.com/watch/episodio-55-feliz-navipez-milo-pecezuelos-4ede5c2f8e257d1043ac4f2d","title":"Episodio 55: Feliz Navipez, Milo - Pecezuelos","thumb":"http://cdnvideo.dolimg.com/cdn_assets/b23bda888d7e796e37452d44101b1cdffb709050.jpg","description":"\u00bfEst\u00e1s preparado? Disfruta al m\u00e1ximo de este episodio.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4ede5c2f8e257d1043ac4f2d","ptitle":"Pecezuelos","phref":"http://videos.disneylatino.com/pecezuelos","publish_date":"December 20, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"23:11","duration_sec":1391,"duration_iso":"T00H23M11S","badge":null,"primaryImageName":"thumb","id":"4eddc8ab86e292aba814b8aa","slug":"episodio-navideno-zack-y-cody-gemelos-a-bordo","href":"http://videos.disneylatino.com/watch/episodio-navideno-zack-y-cody-gemelos-a-bordo-4eddc8ab86e292aba814b8aa","title":"Episodio Navide\u00f1o \u2013 Zack y Cody: Gemelos a bordo","thumb":"http://cdnvideo.dolimg.com/cdn_assets/ef7ba1ba453fd4d11029676f18e24048e2931be1.jpg","description":"\u00bfEst\u00e1s preparado? Disfruta al m\u00e1ximo de este episodio.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4eddc8ab86e292aba814b8aa","ptitle":"Zack y Cody: Gemelos a bordo","phref":"http://videos.disneylatino.com/zack-y-cody-gemelos-a-bordo","publish_date":"December 19, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"22:41","duration_sec":1361,"duration_iso":"T00H22M41S","badge":null,"primaryImageName":"thumb","id":"4eddadd2198c51c4466cca32","slug":"episodio-6-una-historia-de-navidad-jessie","href":"http://videos.disneylatino.com/watch/episodio-6-una-historia-de-navidad-jessie-4eddadd2198c51c4466cca32","title":"Episodio 6: Una historia de Navidad - Jessie","thumb":"http://cdnvideo.dolimg.com/cdn_assets/bcd7010a9e6209a73a51dfc6b0137af844f8ebb1.jpg","description":"\u00bfEres fan de la serie? Entonces no puedes perderte este episodio.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4eddadd2198c51c4466cca32","ptitle":"Jessie","phref":"http://videos.disneylatino.com/jessie","publish_date":"December 19, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"22:43","duration_sec":1363,"duration_iso":"T00H22M43S","badge":null,"primaryImageName":"thumb","id":"4eddbb3f361591812a2876f9","slug":"episodio-48-llego-la-navidad-phineas-and-ferb","href":"http://videos.disneylatino.com/watch/episodio-48-llego-la-navidad-phineas-and-ferb-4eddbb3f361591812a2876f9","title":"\u00a1Lleg\u00f3 la Navidad! - Phineas & Ferb","thumb":"http://cdnvideo.dolimg.com/cdn_assets/29b5747cb940ea2ee81c12d4bb31e3fb67fe115a.jpg","description":"\u00a1Haz click ahora y comienza a disfrutar del especial navide\u00f1o de Phineas y Ferb!","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4eddbb3f361591812a2876f9","ptitle":"Phineas y Ferb","phref":"http://videos.disneylatino.com/phineas-y-ferb","publish_date":"December 19, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"22:02","duration_sec":1322,"duration_iso":"T00H22M02S","badge":null,"primaryImageName":"thumb","id":"4ec6d699cf7148806bd0a113","slug":"episodio-25-cena-para-squonks-par-de-reyes","href":"http://videos.disneylatino.com/watch/episodio-25-cena-para-squonks-par-de-reyes-4ec6d699cf7148806bd0a113","title":"Episodio 25: Cena para Squonks - Par de Reyes","thumb":"http://cdnvideo.dolimg.com/cdn_assets/8b0ea35f5472efb6aa3088a5c16a298ae70ed6b2.jpg","description":"Este episodio incluye risas, enredos y emoci\u00f3n. \u00bfTe lo vas a perder?","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4ec6d699cf7148806bd0a113","ptitle":"Par de Reyes","phref":"http://videos.disneylatino.com/par-de-reyes","publish_date":"December 17, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"22:30","duration_sec":1350,"duration_iso":"T00H22M30S","badge":null,"primaryImageName":"thumb","id":"4ec6ae5f904194ede7ad7c74","slug":"episodio-86-el-subconsciente-de-candace-phineas-and-ferb","href":"http://videos.disneylatino.com/watch/episodio-86-el-subconsciente-de-candace-phineas-and-ferb-4ec6ae5f904194ede7ad7c74","title":"Episodio 86: El subconsciente de Candace - Phineas & Ferb","thumb":"http://cdnvideo.dolimg.com/cdn_assets/aae79cbc345ef1aade6209fc570716862f7b6bd8.jpg","description":"Este episodio es imperdible. Prep\u00e1rate para disfrutar de cada momento.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4ec6ae5f904194ede7ad7c74","ptitle":"Phineas y Ferb","phref":"http://videos.disneylatino.com/phineas-y-ferb","publish_date":"December 17, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"1:45","duration_sec":105,"duration_iso":"T00H01M45S","badge":null,"primaryImageName":"thumb","id":"4ed43ff7bf8637d673076d45","slug":"jabber-deja-tu-marca","href":"http://videos.disneylatino.com/watch/jabber-deja-tu-marca-4ed43ff7bf8637d673076d45","title":"Jabber - Deja tu Marca","thumb":"http://cdnvideo.dolimg.com/cdn_assets/309b5372a8d27298dd71ac59498f0db761f788cd.jpg","description":"Est\u00e1 en nuestras manos hacer del mundo un lugar mejor, y son acciones como \u00e9sta las que ya est\u00e1n haciendo la diferencia.","vType":"Clip","adPattern":"ACC","embedURL":"http://videos.disneylatino.com/embed/4ed43ff7bf8637d673076d45","publish_date":"December 16, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"1:15","duration_sec":75,"duration_iso":"T00H01M15S","badge":null,"primaryImageName":"thumb","id":"4ed43fee026247d673076d45","slug":"dise-o-deja-tu-marca","href":"http://videos.disneylatino.com/watch/dise-o-deja-tu-marca-4ed43fee026247d673076d45","title":"Dise\u00f1o - Deja tu Marca","thumb":"http://cdnvideo.dolimg.com/cdn_assets/e17c964eb491b2d9c4aef34e0202f9ed91d36787.jpg","description":"No te pierdas este conmovedor ejemplo de c\u00f3mo nuestros deseos y sue\u00f1os pueden ser poderosas herramientas para dejar nuestra marca en el mundo.","vType":"Clip","adPattern":"ACC","embedURL":"http://videos.disneylatino.com/embed/4ed43fee026247d673076d45","publish_date":"December 16, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"22:02","duration_sec":1322,"duration_iso":"T00H22M02S","badge":null,"primaryImageName":"thumb","id":"4e9f7f088604b02f284b47c2","slug":"los-hechiceros-de-waverly-place-episodio-62-la-tercera-rueda","href":"http://videos.disneylatino.com/watch/los-hechiceros-de-waverly-place-episodio-62-la-tercera-rueda-4e9f7f088604b02f284b47c2","title":"Episodio 62: La tercera rueda - Los Hechiceros de Waverly Place","thumb":"http://cdnvideo.dolimg.com/cdn_assets/d0e9f30207cfe7bf9fe6513ed98181bfc1fa33bd.jpg","description":"En este episodio, tus personajes favoritos te atrapar\u00e1n una vez m\u00e1s. No dejes de verlo.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e9f7f088604b02f284b47c2","ptitle":"Los hechiceros de Waverly Place","phref":"http://videos.disneylatino.com/los-hechiceros-de-waverly-place","publish_date":"December 12, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"22:10","duration_sec":1330,"duration_iso":"T00H22M10S","badge":null,"primaryImageName":"thumb","id":"4e9fa73986093367a1a1739b","slug":"los-hechiceros-de-waverly-place-episodio-61-come-con-ritmo","href":"http://videos.disneylatino.com/watch/los-hechiceros-de-waverly-place-episodio-61-come-con-ritmo-4e9fa73986093367a1a1739b","title":"Episodio 61: Come con ritmo - Los Hechiceros de Waverly Place","thumb":"http://cdnvideo.dolimg.com/cdn_assets/dd8997aab69e1441ffd7ea57e4b002a41950cadc.jpg","description":"Todo lo que te gusta de esta serie lo encontrar\u00e1s en este episodio.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e9fa73986093367a1a1739b","ptitle":"Los hechiceros de Waverly Place","phref":"http://videos.disneylatino.com/los-hechiceros-de-waverly-place","publish_date":"December 12, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"23:01","duration_sec":1381,"duration_iso":"T00H23M01S","badge":null,"primaryImageName":"thumb","id":"4e9fdcdaf8363bb608b22f73","slug":"art-attack-episodio-15-grandes-hazanas","href":"http://videos.disneylatino.com/watch/art-attack-episodio-15-grandes-hazanas-4e9fdcdaf8363bb608b22f73","title":"Episodio 15: Grandes haza\u00f1as - Art Attack","thumb":"http://cdnvideo.dolimg.com/cdn_assets/47178fd3ecfeecf10edb6145198ff5d13d51d66f.jpg","description":"Revive tus momentos favoritos de este episodio.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e9fdcdaf8363bb608b22f73","ptitle":"Art Attack","phref":"http://videos.disneylatino.com/art-attack","publish_date":"December 12, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"1:27","duration_sec":87,"duration_iso":"T00H01M27S","badge":null,"primaryImageName":"thumb","id":"4ed43ffb6173f7d673076d45","slug":"kailin-y-kasper-deja-tu-marca","href":"http://videos.disneylatino.com/watch/kailin-y-kasper-deja-tu-marca-4ed43ffb6173f7d673076d45","title":"Kailin y Kasper - Deja tu Marca","thumb":"http://cdnvideo.dolimg.com/cdn_assets/58cfca1bd0df8cb180019a338955b7c6d94b2d67.jpg","description":"Podemos cambiar el mundo de muchas maneras. Insp\u00edrate con esta historia de alguien que ya est\u00e1 haciendo una diferencia.","vType":"Clip","adPattern":"ACC","embedURL":"http://videos.disneylatino.com/embed/4ed43ffb6173f7d673076d45","publish_date":"December 12, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"44:08","duration_sec":2648,"duration_iso":"T00H44M08S","badge":null,"primaryImageName":"thumb","id":"4ed1bc1bd20e5e4846d24b1f","slug":"el-show-completo-violetta-en-vivo","href":"http://videos.disneylatino.com/watch/el-show-completo-violetta-en-vivo-4ed1bc1bd20e5e4846d24b1f","title":"El show completo \u2013 Lo mejor de Violetta en Vivo","thumb":"http://cdnvideo.dolimg.com/cdn_assets/48cdf20b5cfb203983578c04306a1d50bfa54272.jpg","description":"\u00a1Reviv\u00ed todo el show de Buenos Aires!","vType":"Featurette","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4ed1bc1bd20e5e4846d24b1f","ptitle":"Violetta","phref":"http://videos.disneylatino.com/violetta","publish_date":"December 10, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"3:30","duration_sec":210,"duration_iso":"T00H03M30S","badge":null,"primaryImageName":"thumb","id":"4e585ab7dae355f7475ada2c","slug":"diario-de-rodaje-tini-y-mechi","href":"http://videos.disneylatino.com/watch/diario-de-rodaje-tini-y-mechi-4e585ab7dae355f7475ada2c","title":"Tini y Mechi - Diario de Rodaje","thumb":"http://cdnvideo.dolimg.com/cdn_assets/33e4f3cb474cce3ede5fd5e88fdf50ba9ebb042a.jpg","description":"\u00a1La realidad no se parece a la ficci\u00f3n! Cuando se apaga la c\u00e1mara, Tini y Mechi son s\u00faper amigas.","vType":"Clip","adPattern":"ACC","embedURL":"http://videos.disneylatino.com/embed/4e585ab7dae355f7475ada2c","ptitle":"Violetta","phref":"http://videos.disneylatino.com/violetta","publish_date":"December 9, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"2:23","duration_sec":143,"duration_iso":"T00H02M23S","badge":null,"primaryImageName":"thumb","id":"4eaa3c2f0ee06d666102306c","slug":"the-u-mix-show-detras-de-escena-lodo-y-diego","href":"http://videos.disneylatino.com/watch/the-u-mix-show-detras-de-escena-lodo-y-diego-4eaa3c2f0ee06d666102306c","title":"Detr\u00e1s de escena \u2013 Lodo y Diego - The U-mix Show","thumb":"http://cdnvideo.dolimg.com/cdn_assets/7b998d6e03d3c014ac7dd4e3fdbfa4c7901d5bd8.jpg","description":"\u00a1Esp\u00eda todo lo que pasa detr\u00e1s de escena!","vType":"Behind The Scenes","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4eaa3c2f0ee06d666102306c","ptitle":"The U-Mix Show","phref":"http://videos.disneylatino.com/the-u-mix-show","publish_date":"December 9, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"25:12","duration_sec":1512,"duration_iso":"T00H25M12S","badge":null,"primaryImageName":"thumb","id":"4e69bf32902ece8f721b67d2","slug":"the-u-mix-show-con-nacho-episodio-9","href":"http://videos.disneylatino.com/watch/the-u-mix-show-con-nacho-episodio-9-4e69bf32902ece8f721b67d2","title":"Episodio 9 - The U-Mix Show con Nacho","thumb":"http://cdnvideo.dolimg.com/cdn_assets/11a9b243bc508c49e7da3f72097eb2c1429253fe.jpg","description":"No te pierdas este fantastico episodio de Nacho junto con Mechi Lambre  y mas invitados","vType":"Clip","adPattern":"ACC","embedURL":"http://videos.disneylatino.com/embed/4e69bf32902ece8f721b67d2","ptitle":"The U-Mix Show","phref":"http://videos.disneylatino.com/the-u-mix-show","publish_date":"December 9, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"22:03","duration_sec":1323,"duration_iso":"T00H22M03S","badge":null,"primaryImageName":"thumb","id":"4e8da1c4ba056451e0d44cae","slug":"stan-el-perro-bloguero-episodio-4-ladra-que-los-angeles-heraldicos-cantaran","href":"http://videos.disneylatino.com/watch/stan-el-perro-bloguero-episodio-4-ladra-que-los-angeles-heraldicos-cantaran-4e8da1c4ba056451e0d44cae","title":"Episodio 4: Ladra, que los \u00e1ngeles her\u00e1ldicos cantar\u00e1n - Stan, el perro bloguero ","thumb":"http://cdnvideo.dolimg.com/cdn_assets/8890f7b3b24cd017a25133b3f6e0623edc9c1287.jpg","description":"Disfruta de momentos emocionantes viendo este episodio completo.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e8da1c4ba056451e0d44cae","ptitle":"Stan, el perro bloguero","phref":"http://videos.disneylatino.com/stan-el-perro-bloguero","publish_date":"December 9, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"21:50","duration_sec":1310,"duration_iso":"T00H21M50S","badge":null,"primaryImageName":"thumb","id":"4e8d86f0fc5da751139edbff","slug":"stan-el-perro-bloguero-episodio-5-stan-genio-matematico","href":"http://videos.disneylatino.com/watch/stan-el-perro-bloguero-episodio-5-stan-genio-matematico-4e8d86f0fc5da751139edbff","title":"Episodio 5: Stan, genio matem\u00e1tico - Stan, el perro bloguero","thumb":"http://cdnvideo.dolimg.com/cdn_assets/4a7166edab75c90ab251001c6f323aa191481d3a.jpg","description":"Todo lo que te gusta de esta serie lo encontrar\u00e1s en este episodio.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e8d86f0fc5da751139edbff","ptitle":"Stan, el perro bloguero","phref":"http://videos.disneylatino.com/stan-el-perro-bloguero","publish_date":"December 9, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"21:50","duration_sec":1310,"duration_iso":"T00H21M50S","badge":null,"primaryImageName":"thumb","id":"4e85e46ca9f455c522d90f85","slug":"austin-and-ally-episodio-11-escritores-y-estrellas-de-mar","href":"http://videos.disneylatino.com/watch/austin-and-ally-episodio-11-escritores-y-estrellas-de-mar-4e85e46ca9f455c522d90f85","title":"Episodio 11: Escritores y Estrellas de mar - Austin & Ally","thumb":"http://cdnvideo.dolimg.com/cdn_assets/1a22e69e9fb37e4cbad96a85b7b5ba51602dca35.jpg","description":"Todo lo que te gusta de esta serie lo encontrar\u00e1s en este episodio.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e85e46ca9f455c522d90f85","ptitle":"Austin & Ally","phref":"http://videos.disneylatino.com/austin-and-ally","publish_date":"December 9, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"23:01","duration_sec":1381,"duration_iso":"T00H23M01S","badge":null,"primaryImageName":"thumb","id":"4ea27b65adaa96f56ac07f3e","slug":"zack-y-cody-gemelos-a-bordo-episodio-53-una-novia-computarizada","href":"http://videos.disneylatino.com/watch/zack-y-cody-gemelos-a-bordo-episodio-53-una-novia-computarizada-4ea27b65adaa96f56ac07f3e","title":"Episodio 53 - Una novia Computarizada - Zack y Cody - Gemelos a bordo","thumb":"http://cdnvideo.dolimg.com/cdn_assets/b7592b7516d805cd40a7a06f72b60aadaed01f26.jpg","description":"Mira este epsiodio de una de tus series favoritas, con los personajes que m\u00e1s te gustan y las historias que no olvidar\u00e1s.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4ea27b65adaa96f56ac07f3e","ptitle":"Zack y Cody: Gemelos a bordo","phref":"http://videos.disneylatino.com/zack-y-cody-gemelos-a-bordo","publish_date":"December 6, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"22:32","duration_sec":1352,"duration_iso":"T00H22M32S","badge":null,"primaryImageName":"thumb","id":"4ec28aed5c2f465793f90fdb","slug":"episodio-63-la-tercera-rueda-los-hechiceros-de-waverly-place","href":"http://videos.disneylatino.com/watch/episodio-63-la-tercera-rueda-los-hechiceros-de-waverly-place-4ec28aed5c2f465793f90fdb","title":"Episodio 63: La tercera rueda - Los Hechiceros de Waverly Place","thumb":"http://cdnvideo.dolimg.com/cdn_assets/dac32cbbbf95b602b0345d08c21427e5490a041b.jpg","description":"Disfruta de momentos emocionantes viendo este episodio completo.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4ec28aed5c2f465793f90fdb","ptitle":"Los hechiceros de Waverly Place","phref":"http://videos.disneylatino.com/los-hechiceros-de-waverly-place","publish_date":"December 5, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"1:20","duration_sec":80,"duration_iso":"T00H01M20S","badge":null,"primaryImageName":"thumb","id":"4ecba878fe580eead74bd28a","slug":"abracadubre-promo","href":"http://videos.disneylatino.com/watch/abracadubre-promo-4ecba878fe580eead74bd28a","title":"Promo - Abracadubre","thumb":"http://cdnvideo.dolimg.com/cdn_assets/effd8ba1a01e4cfab2e33ef4c008763f5de6bd73.jpg","description":"Este fragmento te transportar\u00e1 a un mundo m\u00e1gico. \u00a1Disfr\u00fatalo!","vType":"Trailer - Movie","adPattern":"C","embedURL":"http://videos.disneylatino.com/embed/4ecba878fe580eead74bd28a","publish_date":"December 5, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"0:30","duration_sec":30,"duration_iso":"T00H00M30S","badge":null,"primaryImageName":"thumb","id":"4ecba874ec44aeead74bd28a","slug":"campamento-lake-bottom-promo","href":"http://videos.disneylatino.com/watch/campamento-lake-bottom-promo-4ecba874ec44aeead74bd28a","title":"Campamento Lake Bottom: Promo","thumb":"http://cdnvideo.dolimg.com/cdn_assets/bad807ee71fd49d17a0691dd6c9cc172dd0f0eeb.jpg","description":"Este fragmento te transportar\u00e1 a un mundo m\u00e1gico. \u00a1Disfr\u00fatalo!","vType":"Trailer - Movie","adPattern":"C","embedURL":"http://videos.disneylatino.com/embed/4ecba874ec44aeead74bd28a","ptitle":"Campamento Lake Bottom","phref":"http://videos.disneylatino.com/camp-lakebottom","publish_date":"December 5, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"}],"style":{"images":{}},"translations":{"see_all":"See All"},"see_all_text":"See All"},{"view":"slider","ref":"1-3","type":"video","count":143,"title":"Disney XD","data":[{"duration":"1:10","duration_sec":70,"duration_iso":"T00H01M10S","badge":null,"primaryImageName":"thumb","id":"4e8cf41797ab552564402b1c","slug":"kick-buttowski-disco-stars","href":"http://videos.disneylatino.com/watch/kick-buttowski-disco-stars-4e8cf41797ab552564402b1c","title":"Disco Stars - Kick Buttowski","thumb":"http://cdnvideo.dolimg.com/cdn_assets/72d53db911f8497d9df093967992e2c1d3e61d3e.jpg","description":"Kick, Gunther, Brad y el resto del elenco lucen sus mejores pasos, al ritmo de m\u00fasica disco.","vType":"Clip","adPattern":"ACC","embedURL":"http://videos.disneylatino.com/embed/4e8cf41797ab552564402b1c","ptitle":"Kick Buttowski: medio doble de riesgo","phref":"http://videos.disneylatino.com/kick-buttowski-medio-doble-de-riesgo","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"21:58","duration_sec":1318,"duration_iso":"T00H21M58S","badge":null,"primaryImageName":"thumb","id":"4ec495fa71ff738f5210f2cb","slug":"episodio-9-los-simuladores-bondi-band","href":"http://videos.disneylatino.com/watch/episodio-9-los-simuladores-bondi-band-4ec495fa71ff738f5210f2cb","title":"Episodio 9: Los simuladores - Bondi Band","thumb":"http://cdnvideo.dolimg.com/cdn_assets/defef7c4ed523cec5bc6fdbea7f35957b1a51bc4.jpg","description":"\u00bfEres fan de la serie? Entonces no puedes perderte este episodio.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4ec495fa71ff738f5210f2cb","ptitle":"Bondi Band","phref":"http://videos.disneylatino.com/bondi-band","publish_date":"December 18, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"22:07","duration_sec":1327,"duration_iso":"T00H22M07S","badge":null,"primaryImageName":"thumb","id":"4ec47b29f30a0dffe8ce60b9","slug":"episodio-8-la-pelicula-debe-continuar-bondi-band","href":"http://videos.disneylatino.com/watch/episodio-8-la-pelicula-debe-continuar-bondi-band-4ec47b29f30a0dffe8ce60b9","title":"Episodio 8: La pel\u00edcula debe continuar - Bondi Band","thumb":"http://cdnvideo.dolimg.com/cdn_assets/6f4ca623c1658f34592e272f806de1d93136cf60.jpg","description":"Revive tus momentos favoritos de este episodio.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4ec47b29f30a0dffe8ce60b9","ptitle":"Bondi Band","phref":"http://videos.disneylatino.com/bondi-band","publish_date":"December 18, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"7:04","duration_sec":424,"duration_iso":"T00H07M04S","badge":null,"primaryImageName":"thumb","id":"4ec46057a539d744b8db8bd6","slug":"episodio-2-no-toques-mi-sirena-como-hermanos","href":"http://videos.disneylatino.com/watch/episodio-2-no-toques-mi-sirena-como-hermanos-4ec46057a539d744b8db8bd6","title":"Episodio 2: No toques mi sirena - Como hermanos","thumb":"http://cdnvideo.dolimg.com/cdn_assets/2471a99902186bc4d98fcdb3afde24bc4725b6ec.jpg","description":"Haz click y disfruta de este episodio completo. \u00a1Te encantar\u00e1!","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4ec46057a539d744b8db8bd6","ptitle":"Como Hermanos","phref":"http://videos.disneylatino.com/como-hermanos","publish_date":"December 18, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"22:23","duration_sec":1343,"duration_iso":"T00H22M23S","badge":null,"primaryImageName":"thumb","id":"4ec46055b562d744b8db8bd6","slug":"episodio-61-la-voluntad-de-lacerta-beyblade","href":"http://videos.disneylatino.com/watch/episodio-61-la-voluntad-de-lacerta-beyblade-4ec46055b562d744b8db8bd6","title":"Episodio 61: La voluntad de Lacerta - Beyblade","thumb":"http://cdnvideo.dolimg.com/cdn_assets/dd8727517b4197150b32d61cf6961b2c2c23e484.jpg","description":"Mira este epsiodio de una de tus series favoritas, con los personajes que m\u00e1s te gustan y las historias que no olvidar\u00e1s.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4ec46055b562d744b8db8bd6","ptitle":"Beyblade: Metal fusion","phref":"http://videos.disneylatino.com/beyblade-metal-fusion","publish_date":"December 18, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"22:23","duration_sec":1343,"duration_iso":"T00H22M23S","badge":null,"primaryImageName":"thumb","id":"4ec452ed0415c356f5b6c0fe","slug":"episodio-60-comienza-el-campeonato-mundial-beyblade","href":"http://videos.disneylatino.com/watch/episodio-60-comienza-el-campeonato-mundial-beyblade-4ec452ed0415c356f5b6c0fe","title":"Episodio 60: \u00a1Comienza el campeonato mundial! - Beyblade","thumb":"http://cdnvideo.dolimg.com/cdn_assets/5707a5ecd0a204b7d3f500193117944262400561.jpg","description":"En este episodio, tus personajes favoritos te atrapar\u00e1n una vez m\u00e1s. No dejes de verlo.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4ec452ed0415c356f5b6c0fe","ptitle":"Beyblade: Metal fusion","phref":"http://videos.disneylatino.com/beyblade-metal-fusion","publish_date":"December 18, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"24:20","duration_sec":1460,"duration_iso":"T00H24M20S","badge":null,"primaryImageName":"thumb","id":"4ec7347a447541400186edcb","slug":"episodio-1-el-mundo-bajo-nuestros-pies-primera-parte-bajoterra","href":"http://videos.disneylatino.com/watch/episodio-1-el-mundo-bajo-nuestros-pies-primera-parte-bajoterra-4ec7347a447541400186edcb","title":"Episodio 1: El mundo bajo nuestros pies primera parte - Bajoterra","thumb":"http://cdnvideo.dolimg.com/cdn_assets/a31156c30d3e94797acdcceb3969b880a934a556.jpg","description":"Este episodio es tan divertido que no podr\u00e1s dejar de verlo hasta el final.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4ec7347a447541400186edcb","ptitle":"Bajoterra","phref":"http://videos.disneylatino.com/bajoterra","publish_date":"December 17, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"22:58","duration_sec":1378,"duration_iso":"T00H22M58S","badge":null,"primaryImageName":"thumb","id":"4ec6c9302e455f93407b9fa1","slug":"episodio-35-el-coach-peter-punk","href":"http://videos.disneylatino.com/watch/episodio-35-el-coach-peter-punk-4ec6c9302e455f93407b9fa1","title":"Episodio 35: El coach - Peter Punk","thumb":"http://cdnvideo.dolimg.com/cdn_assets/c4bbf337771a13f6b53c51926140fde7890515a4.jpg","description":"Tus personajes favoritos hacen de las suyas en este episodio completo.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4ec6c9302e455f93407b9fa1","ptitle":"Peter Punk","phref":"http://videos.disneylatino.com/peter-punk","publish_date":"December 17, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"23:00","duration_sec":1380,"duration_iso":"T00H23M00S","badge":null,"primaryImageName":"thumb","id":"4ec55f1ab8bba73dffe3f33a","slug":"episodio-32-la-novia-de-muji-pucca","href":"http://videos.disneylatino.com/watch/episodio-32-la-novia-de-muji-pucca-4ec55f1ab8bba73dffe3f33a","title":"Episodio 32: La novia de Muji - Pucca","thumb":"http://cdnvideo.dolimg.com/cdn_assets/f12ea3d2ed2817afcd4f6f060c7443bf8c8041e9.jpg","description":"Disfruta de este episodio de una de tus series favoritas.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4ec55f1ab8bba73dffe3f33a","ptitle":"Pucca","phref":"http://videos.disneylatino.com/pucca","publish_date":"December 17, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"23:00","duration_sec":1380,"duration_iso":"T00H23M00S","badge":null,"primaryImageName":"thumb","id":"4ec5444bd16e18b1f66e6be6","slug":"episodio-31-amor-imborrable-pucca","href":"http://videos.disneylatino.com/watch/episodio-31-amor-imborrable-pucca-4ec5444bd16e18b1f66e6be6","title":"Episodio 31: Amor imborrable - Pucca","thumb":"http://cdnvideo.dolimg.com/cdn_assets/1e664334d8bd2799063da7f19b291755d2c4c400.jpg","description":"Este episodio est\u00e1 lleno de momentos memorables. \u00a1Disfr\u00fatalo!","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4ec5444bd16e18b1f66e6be6","ptitle":"Pucca","phref":"http://videos.disneylatino.com/pucca","publish_date":"December 17, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"22:57","duration_sec":1377,"duration_iso":"T00H22M57S","badge":null,"primaryImageName":"thumb","id":"4ec5444aa49538b1f66e6be6","slug":"episodio-30-palillos-en-peligro-pucca","href":"http://videos.disneylatino.com/watch/episodio-30-palillos-en-peligro-pucca-4ec5444aa49538b1f66e6be6","title":"Episodio 30: Palillos en peligro - Pucca","thumb":"http://cdnvideo.dolimg.com/cdn_assets/a83eeb3ecebf085c8991b1d9e3247f32da261cc8.jpg","description":"Revive tus momentos favoritos de este episodio.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4ec5444aa49538b1f66e6be6","ptitle":"Pucca","phref":"http://videos.disneylatino.com/pucca","publish_date":"December 17, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"25:30","duration_sec":1530,"duration_iso":"T00H25M30S","badge":null,"primaryImageName":"thumb","id":"4ec55f1bfb63c73dffe3f33a","slug":"episodio-45-planeta-hulk-el-escuadron-de-superheroes","href":"http://videos.disneylatino.com/watch/episodio-45-planeta-hulk-el-escuadron-de-superheroes-4ec55f1bfb63c73dffe3f33a","title":"Episodio 45: Planeta Hulk - El escuadr\u00f3n de superh\u00e9roes","thumb":"http://cdnvideo.dolimg.com/cdn_assets/caca6a38234347b4e82d17503aeefba0e3321c03.jpg","description":"Si a\u00fan no has visto este episodio, haz click y disfr\u00fatalo ahora porque es imperdible.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4ec55f1bfb63c73dffe3f33a","ptitle":"El escuadr\u00f3n de superh\u00e9roes","phref":"http://videos.disneylatino.com/el-escuadr-n-de-superh-roes","publish_date":"December 17, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"22:48","duration_sec":1368,"duration_iso":"T00H22M48S","badge":null,"primaryImageName":"thumb","id":"4ec5af930806378902068d2f","slug":"episodio-11-no-hables-con-extranos-bondi-band","href":"http://videos.disneylatino.com/watch/episodio-11-no-hables-con-extranos-bondi-band-4ec5af930806378902068d2f","title":"Episodio 11: No hables con extra\u00f1os - Bondi Band","thumb":"http://cdnvideo.dolimg.com/cdn_assets/71cbacbd1a88e033df3294f8d1a132e08bf537ac.jpg","description":"Tus personajes favoritos hacen de las suyas en este episodio completo.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4ec5af930806378902068d2f","ptitle":"Bondi Band","phref":"http://videos.disneylatino.com/bondi-band","publish_date":"December 17, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"22:19","duration_sec":1339,"duration_iso":"T00H22M19S","badge":null,"primaryImageName":"thumb","id":"4ec5a22ae4d55b6b4b19fbbf","slug":"episodio-10-el-triunfo-de-miss-c-lebrity-bondi-band","href":"http://videos.disneylatino.com/watch/episodio-10-el-triunfo-de-miss-c-lebrity-bondi-band-4ec5a22ae4d55b6b4b19fbbf","title":"Episodio 10: El triunfo de Miss C. Lebrity - Bondi Band","thumb":"http://cdnvideo.dolimg.com/cdn_assets/43f6183a0509d69e986695df47d71a113b9f1f90.jpg","description":"\u00a1El disfrute est\u00e1 garantizado con este episodio! M\u00edralo.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4ec5a22ae4d55b6b4b19fbbf","ptitle":"Bondi Band","phref":"http://videos.disneylatino.com/bondi-band","publish_date":"December 17, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"22:53","duration_sec":1373,"duration_iso":"T00H22M53S","badge":null,"primaryImageName":"thumb","id":"4ec68623117296844c265ef1","slug":"episodio-2-hogar-ninja-go","href":"http://videos.disneylatino.com/watch/episodio-2-hogar-ninja-go-4ec68623117296844c265ef1","title":"Episodio 2: Hogar - Ninja Go","thumb":"http://cdnvideo.dolimg.com/cdn_assets/913be4c08e309471d58c0f246f62d2f6838f1cea.jpg","description":"Este episodio es realmente imperdible. \u00a1M\u00edralo!","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4ec68623117296844c265ef1","ptitle":"Ninja Go","phref":"http://videos.disneylatino.com/ninja-go","publish_date":"December 17, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"22:32","duration_sec":1352,"duration_iso":"T00H22M32S","badge":null,"primaryImageName":"thumb","id":"4ec8c7643e74ab92f68c1712","slug":"episodio-17-la-llegada-del-conquistador-los-vengadores","href":"http://videos.disneylatino.com/watch/episodio-17-la-llegada-del-conquistador-los-vengadores-4ec8c7643e74ab92f68c1712","title":"Episodio 17: La llegada del Conquistador - Los Vengadores","thumb":"http://cdnvideo.dolimg.com/cdn_assets/f6850bfc8ef2013859a655d7c71019961326abfe.jpg","description":"Haz click y disfruta de este episodio completo. \u00a1Te encantar\u00e1!","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4ec8c7643e74ab92f68c1712","ptitle":"Los Vengadores: los h\u00e9roes m\u00e1s poderosos del planeta","phref":"http://videos.disneylatino.com/los-vengadores-los-h-roes-m-s-poderosos-del-planeta","publish_date":"December 16, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"22:32","duration_sec":1352,"duration_iso":"T00H22M32S","badge":null,"primaryImageName":"thumb","id":"4ec8c70bdd7e5b92f68c1712","slug":"episodio-16-el-hombre-que-robo-el-manana-los-vengadores","href":"http://videos.disneylatino.com/watch/episodio-16-el-hombre-que-robo-el-manana-los-vengadores-4ec8c70bdd7e5b92f68c1712","title":"Episodio 16: El hombre que rob\u00f3 el ma\u00f1ana - Los Vengadores","thumb":"http://cdnvideo.dolimg.com/cdn_assets/367af75261e71275199b4b50a3c20c731c2df7b8.jpg","description":"\u00bfEres fan de la serie? Entonces no puedes perderte este episodio.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4ec8c70bdd7e5b92f68c1712","ptitle":"Los Vengadores: los h\u00e9roes m\u00e1s poderosos del planeta","phref":"http://videos.disneylatino.com/los-vengadores-los-h-roes-m-s-poderosos-del-planeta","publish_date":"December 16, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"22:57","duration_sec":1377,"duration_iso":"T00H22M57S","badge":null,"primaryImageName":"thumb","id":"4eadbeb62705718997de7543","slug":"pucca-episodio-29-venganza-invencible","href":"http://videos.disneylatino.com/watch/pucca-episodio-29-venganza-invencible-4eadbeb62705718997de7543","title":"Pucca: Episodio 29 - Venganza Invencible","thumb":"http://cdnvideo.dolimg.com/cdn_assets/ee8889654966409eefe351233ddfdbe8ce681489.jpg","description":"Disfruta de este episodio de una de tus series favoritas.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4eadbeb62705718997de7543","ptitle":"Pucca","phref":"http://videos.disneylatino.com/pucca","publish_date":"December 16, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"22:57","duration_sec":1377,"duration_iso":"T00H22M57S","badge":null,"primaryImageName":"thumb","id":"4ea907be36eea6aeba8e4ffd","slug":"pucca-episodio-28-puccapatra","href":"http://videos.disneylatino.com/watch/pucca-episodio-28-puccapatra-4ea907be36eea6aeba8e4ffd","title":"Pucca: Episodio 28 - Puccapatra","thumb":"http://cdnvideo.dolimg.com/cdn_assets/a641d77a182973a3a39e5f2816313d9fabb747d6.jpg","description":"Este episodio es tan divertido que no podr\u00e1s dejar de verlo hasta el final.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4ea907be36eea6aeba8e4ffd","ptitle":"Pucca","phref":"http://videos.disneylatino.com/pucca","publish_date":"December 16, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"22:20","duration_sec":1340,"duration_iso":"T00H22M20S","badge":null,"primaryImageName":"thumb","id":"4ecaa9ad24983d18d889f1bf","slug":"episodio-11-venenoso-ultimate-spider-man","href":"http://videos.disneylatino.com/watch/episodio-11-venenoso-ultimate-spider-man-4ecaa9ad24983d18d889f1bf","title":"Episodio 11: Venenoso - Ultimate Spider-Man","thumb":"http://cdnvideo.dolimg.com/cdn_assets/50972ffca1867aecf9222da4e002b6823be0cda0.jpg","description":"Disfruta de este episodio de una de tus series favoritas.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4ecaa9ad24983d18d889f1bf","ptitle":"Ultimate Spider-Man","phref":"http://videos.disneylatino.com/ultimate-spider-man","publish_date":"December 16, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"22:32","duration_sec":1352,"duration_iso":"T00H22M32S","badge":null,"primaryImageName":"thumb","id":"4ecaa9a358558d18d889f1bf","slug":"episodio-18-la-dinastia-kang-los-vengadores","href":"http://videos.disneylatino.com/watch/episodio-18-la-dinastia-kang-los-vengadores-4ecaa9a358558d18d889f1bf","title":"Episodio 18: La dinast\u00eda Kang - Los Vengadores","thumb":"http://cdnvideo.dolimg.com/cdn_assets/ac6be4c7413402749f6f58d87919332461ddd24a.jpg","description":"Este episodio est\u00e1 lleno de momentos memorables. \u00a1Disfr\u00fatalo!","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4ecaa9a358558d18d889f1bf","ptitle":"Los Vengadores: los h\u00e9roes m\u00e1s poderosos del planeta","phref":"http://videos.disneylatino.com/los-vengadores-los-h-roes-m-s-poderosos-del-planeta","publish_date":"December 16, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"18:48","duration_sec":1128,"duration_iso":"T00H18M48S","badge":null,"primaryImageName":"thumb","id":"4eafff7bf713c7efe190a0c0","slug":"just-kidding-solo-es-juego-episodio-1","href":"http://videos.disneylatino.com/watch/just-kidding-solo-es-juego-episodio-1-4eafff7bf713c7efe190a0c0","title":"S\u00f3lo es juego: Episodio 1 - Just Kidding","thumb":"http://cdnvideo.dolimg.com/cdn_assets/af490ef4fd588b46d29b43f2d83f86646d26843f.jpg","description":"Mira este epsiodio de una de tus series favoritas, con los personajes que m\u00e1s te gustan y las historias que no olvidar\u00e1s.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4eafff7bf713c7efe190a0c0","publish_date":"December 9, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"22:01","duration_sec":1321,"duration_iso":"T00H22M01S","badge":null,"primaryImageName":"thumb","id":"4ea8fa56aa900d66c942306d","slug":"kick-buttowski-medio-doble-de-riesgo-episodio-43-monique-y-yo","href":"http://videos.disneylatino.com/watch/kick-buttowski-medio-doble-de-riesgo-episodio-43-monique-y-yo-4ea8fa56aa900d66c942306d","title":"Episodio 43 - Monique y yo - Kick Buttowski - Medio doble de riesgo","thumb":"http://cdnvideo.dolimg.com/cdn_assets/916dca856caa272af724836cc0cfd105e59045d3.jpg","description":"Todo lo que te gusta de esta serie lo encontrar\u00e1s en este episodio.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4ea8fa56aa900d66c942306d","ptitle":"Kick Buttowski: medio doble de riesgo","phref":"http://videos.disneylatino.com/kick-buttowski-medio-doble-de-riesgo","publish_date":"December 6, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"23:20","duration_sec":1400,"duration_iso":"T00H23M20S","badge":null,"primaryImageName":"thumb","id":"4eaa71d39fa00299e6c0bb82","slug":"randy-cunningham-episodio-1-el-ultimo-ba-o-de-la-izquierda","href":"http://videos.disneylatino.com/watch/randy-cunningham-episodio-1-el-ultimo-ba-o-de-la-izquierda-4eaa71d39fa00299e6c0bb82","title":"Episodio 1 - El \u00faltimo ba\u00f1o de la izquierda - Randy Cunningham","thumb":"http://cdnvideo.dolimg.com/cdn_assets/fb3c9d1420c94e16a5645dab729b56a4e1394ab6.jpg","description":"Si a\u00fan no has visto este episodio, haz click y disfr\u00fatalo ahora porque es imperdible.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4eaa71d39fa00299e6c0bb82","ptitle":"Randy Cunningham: Ninja total","phref":"http://videos.disneylatino.com/randy-cunningham-ninja-total","publish_date":"December 6, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"22:43","duration_sec":1363,"duration_iso":"T00H22M43S","badge":null,"primaryImageName":"thumb","id":"4eb38f5e3b5522fefff0f278","slug":"episodio-3-la-casa-de-los-1000-mocos-randy-cunningham","href":"http://videos.disneylatino.com/watch/episodio-3-la-casa-de-los-1000-mocos-randy-cunningham-4eb38f5e3b5522fefff0f278","title":"Episodio 3 - La casa de los 1000 mocos - Randy Cunningham","thumb":"http://cdnvideo.dolimg.com/cdn_assets/ff33c91dc21246f89252c8597a2862b4425bb243.jpg","description":"Revive tus momentos favoritos de este episodio.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4eb38f5e3b5522fefff0f278","ptitle":"Randy Cunningham: Ninja total","phref":"http://videos.disneylatino.com/randy-cunningham-ninja-total","publish_date":"December 6, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"23:26","duration_sec":1406,"duration_iso":"T00H23M26S","badge":null,"primaryImageName":"thumb","id":"4eb2ab5f7a2bbc665f9546f9","slug":"episodio-2-el-rey-del-chismorreo-randy-cunningham","href":"http://videos.disneylatino.com/watch/episodio-2-el-rey-del-chismorreo-randy-cunningham-4eb2ab5f7a2bbc665f9546f9","title":"Episodio 2 - El Rey del chismorreo - Randy Cunningham ","thumb":"http://cdnvideo.dolimg.com/cdn_assets/a6e87320d83107c1a7dcf60ce989e28d652ea804.jpg","description":"\u00a1Haz click ahora y comienza a disfrutar de este episodio!","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4eb2ab5f7a2bbc665f9546f9","ptitle":"Randy Cunningham: Ninja total","phref":"http://videos.disneylatino.com/randy-cunningham-ninja-total","publish_date":"December 6, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"}],"style":{"images":{}},"translations":{"see_all":"See All"},"see_all_text":"See All"},{"view":"slider","ref":"1-4","type":"video","count":19,"title":"Episodios completos","data":[{"duration":"23:32","duration_sec":1412,"duration_iso":"T00H23M32S","badge":null,"primaryImageName":"thumb","id":"4e904db6bc507c2a1de2f10d","slug":"a-todo-ritmo-episodio-36-a-todo-solicitar","href":"http://videos.disneylatino.com/watch/a-todo-ritmo-episodio-36-a-todo-solicitar-4e904db6bc507c2a1de2f10d","title":"A Todo Ritmo: Episodio 36 - A todo Solicitar","thumb":"http://cdnvideo.dolimg.com/cdn_assets/2e75a7b536e0e34224c60b6b0e510f26f32e24a8.jpg","description":"Todo lo que te gusta de esta serie lo encontrar\u00e1s en este episodio.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e904db6bc507c2a1de2f10d","ptitle":"A todo ritmo","phref":"http://videos.disneylatino.com/a-todo-ritmo","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"22:31","duration_sec":1351,"duration_iso":"T00H22M31S","badge":null,"primaryImageName":"thumb","id":"4e9fdcda4a6c5bb608b22f73","slug":"phineas-y-ferb-episodio-27-el-monstruo-del-lago-nariz","href":"http://videos.disneylatino.com/watch/phineas-y-ferb-episodio-27-el-monstruo-del-lago-nariz-4e9fdcda4a6c5bb608b22f73","title":"Episodio 27: El monstruo del Lago Nariz - Phineas y Ferb","thumb":"http://cdnvideo.dolimg.com/cdn_assets/939a05fdbe58cff50b8397729784fa5c718324a8.jpg","description":"Este episodio es realmente imperdible. \u00a1M\u00edralo!","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e9fdcda4a6c5bb608b22f73","ptitle":"Phineas y Ferb","phref":"http://videos.disneylatino.com/phineas-y-ferb","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"22:01","duration_sec":1321,"duration_iso":"T00H22M01S","badge":null,"primaryImageName":"thumb","id":"4ea2a39ec6fdaedf4410b96a","slug":"programa-de-talentos-episodio-27-programa-para-beb-s","href":"http://videos.disneylatino.com/watch/programa-de-talentos-episodio-27-programa-para-beb-s-4ea2a39ec6fdaedf4410b96a","title":"Episodio 27: Programa para beb\u00e9s - Programa de Talentos","thumb":"http://cdnvideo.dolimg.com/cdn_assets/7fdbc9bae747dfd30097f1d544e936942a5e0007.jpg","description":"En este episodio, tus personajes favoritos te atrapar\u00e1n una vez m\u00e1s. No dejes de verlo.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4ea2a39ec6fdaedf4410b96a","ptitle":"Programa de talentos","phref":"http://videos.disneylatino.com/programa-de-talentos","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"22:32","duration_sec":1352,"duration_iso":"T00H22M32S","badge":null,"primaryImageName":"thumb","id":"4e83fe27fdd7292d310123c6","slug":"jessie-episodio-11-eres-mas-cool-que-un-nino-de-quinto-grado","href":"http://videos.disneylatino.com/watch/jessie-episodio-11-eres-mas-cool-que-un-nino-de-quinto-grado-4e83fe27fdd7292d310123c6","title":"Episodio 11: \u00bfEres m\u00e1s cool que un ni\u00f1o de quinto grado? - Jessie","thumb":"http://cdnvideo.dolimg.com/cdn_assets/66d3b556908c8dd51b241855b17257d0f254cb56.jpg","description":"Todo lo que te gusta de esta serie lo encontrar\u00e1s en este episodio.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e83fe27fdd7292d310123c6","ptitle":"Jessie","phref":"http://videos.disneylatino.com/jessie","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"22:47","duration_sec":1367,"duration_iso":"T00H22M47S","badge":null,"primaryImageName":"thumb","id":"4ea329bc31eadac9fd501de9","slug":"randy-cunningham-episodio-4-el-monstruo-del-volcan","href":"http://videos.disneylatino.com/watch/randy-cunningham-episodio-4-el-monstruo-del-volcan-4ea329bc31eadac9fd501de9","title":"Episodio 4: El monstruo del volc\u00e1n\u00a0- Randy Cunningham","thumb":"http://cdnvideo.dolimg.com/cdn_assets/47aa34aab96bd874e04a2eb3670fd37ffaadb1d1.jpg","description":"En este episodio, tus personajes favoritos te atrapar\u00e1n una vez m\u00e1s. No dejes de verlo.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4ea329bc31eadac9fd501de9","ptitle":"Randy Cunningham: Ninja total","phref":"http://videos.disneylatino.com/randy-cunningham-ninja-total","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"21:52","duration_sec":1312,"duration_iso":"T00H21M52S","badge":null,"primaryImageName":"thumb","id":"4e87c3c0e5eddec929e2419a","slug":"gravity-falls-episodio-3","href":"http://videos.disneylatino.com/watch/gravity-falls-episodio-3-4e87c3c0e5eddec929e2419a","title":"Episodio 3: Los cazadores de cabezas - Gravity Falls","thumb":"http://cdnvideo.dolimg.com/cdn_assets/78df86126505b0968e7d7c3200a772cf693e9a00.jpg","description":"Si a\u00fan no has visto este episodio, disfr\u00fatalo ahora porque es imperdible.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e87c3c0e5eddec929e2419a","ptitle":"Gravity Falls: un verano de misterio","phref":"http://videos.disneylatino.com/gravity-falls-un-verano-de-misterio","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"22:48","duration_sec":1368,"duration_iso":"T00H22M48S","badge":null,"primaryImageName":"thumb","id":"4e8667082373aedc102882d8","slug":"pecezuelos-episodio-31-la-atareada-bea-la-revolucion-de-las-maquinas","href":"http://videos.disneylatino.com/watch/pecezuelos-episodio-31-la-atareada-bea-la-revolucion-de-las-maquinas-4e8667082373aedc102882d8","title":"Episodio 31 - La atareada Bea: La revoluci\u00f3n de las m\u00e1quinas","thumb":"http://cdnvideo.dolimg.com/cdn_assets/17d4fdbdccffa77ffa150b032afc82d70c0828b2.jpg","description":"Haz click y disfruta de este episodio completo. \u00a1Te encantar\u00e1!","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e8667082373aedc102882d8","ptitle":"Pecezuelos","phref":"http://videos.disneylatino.com/pecezuelos","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"21:45","duration_sec":1305,"duration_iso":"T00H21M45S","badge":null,"primaryImageName":"thumb","id":"4ea35f54e5ff82f0b06e4de2","slug":"stan-el-perro-bloguero-episodio-2-rapidos-y-peludos","href":"http://videos.disneylatino.com/watch/stan-el-perro-bloguero-episodio-2-rapidos-y-peludos-4ea35f54e5ff82f0b06e4de2","title":"Episodio 2: R\u00e1pidos y peludos - Stan, el perro bloguero","thumb":"http://cdnvideo.dolimg.com/cdn_assets/d4bbb385b30b6867be612a59abb8415c6ab541f8.jpg","description":"No te pierdas los momentos inolvidables que incluye este episodio.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4ea35f54e5ff82f0b06e4de2","ptitle":"Stan, el perro bloguero","phref":"http://videos.disneylatino.com/stan-el-perro-bloguero","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"23:16","duration_sec":1396,"duration_iso":"T00H23M16S","badge":null,"primaryImageName":"thumb","id":"4e882199ce0b2c9e8d88818d","slug":"episodio-26-reina-danz-programa-de-talentos","href":"http://videos.disneylatino.com/watch/episodio-26-reina-danz-programa-de-talentos-4e882199ce0b2c9e8d88818d","title":"Episodio 26: Reina Danz - Programa de Talentos","thumb":"http://cdnvideo.dolimg.com/cdn_assets/f1b7f0fc037c37b00c21bc6a477ebd3aca783f1d.jpg","description":"Si a\u00fan no has visto este episodio, haz click y disfr\u00fatalo ahora porque es imperdible.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e882199ce0b2c9e8d88818d","ptitle":"Programa de talentos","phref":"http://videos.disneylatino.com/programa-de-talentos","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"21:27","duration_sec":1287,"duration_iso":"T00H21M27S","badge":null,"primaryImageName":"thumb","id":"4e73a5e0448bd9c8e3e67800","slug":"the-u-mix-show-con-dani-episodio-19","href":"http://videos.disneylatino.com/watch/the-u-mix-show-con-dani-episodio-19-4e73a5e0448bd9c8e3e67800","title":"Episodio 19 - The U-Mix Show con Dani","thumb":"http://cdnvideo.dolimg.com/cdn_assets/0097b1fb3b126d3723c684b072782b7c5ca3a47f.jpg","description":"\u00a1Teen Beach Movie en The U-Mix Show!","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e73a5e0448bd9c8e3e67800","ptitle":"The U-Mix Show","phref":"http://videos.disneylatino.com/the-u-mix-show","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"20:26","duration_sec":1226,"duration_iso":"T00H20M26S","badge":null,"primaryImageName":"thumb","id":"4e87de902323a810cff9a5f0","slug":"gravity-falls-episodio-5-la-tienda-embrujada","href":"http://videos.disneylatino.com/watch/gravity-falls-episodio-5-la-tienda-embrujada-4e87de902323a810cff9a5f0","title":"Episodio 5: La tienda embrujada - Gravity Falls","thumb":"http://cdnvideo.dolimg.com/cdn_assets/5a7fbbcef3459bf1d259898c99fc55f930bec44c.jpg","description":"Este episodio es imperdible. Prep\u00e1rate para disfrutar de cada momento.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e87de902323a810cff9a5f0","ptitle":"Gravity Falls: un verano de misterio","phref":"http://videos.disneylatino.com/gravity-falls-un-verano-de-misterio","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"22:34","duration_sec":1354,"duration_iso":"T00H22M34S","badge":null,"primaryImageName":"thumb","id":"4e92084c3ea9a02ebfeb47c2","slug":"episodio-10-subamos-al-tren-que-tren-jessie","href":"http://videos.disneylatino.com/watch/episodio-10-subamos-al-tren-que-tren-jessie-4e92084c3ea9a02ebfeb47c2","title":"Episodio 10: \u00a1Subamos al tren!... \u00bfQu\u00e9 tren? - Jessie","thumb":"http://cdnvideo.dolimg.com/cdn_assets/1c9f54cef78a7c16682e496f9401edfb433d973b.jpg","description":"\u00bfYa disfrutaste de este episodio en TV? Ahora rev\u00edvelo completo aqu\u00ed.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e92084c3ea9a02ebfeb47c2","ptitle":"Jessie","phref":"http://videos.disneylatino.com/jessie","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"21:47","duration_sec":1307,"duration_iso":"T00H21M47S","badge":null,"primaryImageName":"thumb","id":"4e8d367ab63e363c3fe111bc","slug":"stan-el-perro-bloguero-episodio-3-el-perro-y-el-cerdo","href":"http://videos.disneylatino.com/watch/stan-el-perro-bloguero-episodio-3-el-perro-y-el-cerdo-4e8d367ab63e363c3fe111bc","title":"Episodio 3: El perro y el cerdo - Stan, el perro bloguero","thumb":"http://cdnvideo.dolimg.com/cdn_assets/94a66af19264c1db2a112d79f96c2e8f4793584b.jpg","description":"Este es el episodio completo, as\u00ed que disfr\u00fatalo de principio a fin.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e8d367ab63e363c3fe111bc","ptitle":"Stan, el perro bloguero","phref":"http://videos.disneylatino.com/stan-el-perro-bloguero","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"23:02","duration_sec":1382,"duration_iso":"T00H23M02S","badge":null,"primaryImageName":"thumb","id":"4e90ab9630aef688390e0628","slug":"a-todo-ritmo-episodio-37-a-todo-tunel","href":"http://videos.disneylatino.com/watch/a-todo-ritmo-episodio-37-a-todo-tunel-4e90ab9630aef688390e0628","title":"Episodio 37: A todo t\u00fanel - A Todo Ritmo","thumb":"http://cdnvideo.dolimg.com/cdn_assets/7a0f8d8f991ae90c9f5ecdb7010a7350103adbed.jpg","description":"Disfruta de este episodio completo de una de tus series favoritas.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e90ab9630aef688390e0628","ptitle":"A todo ritmo","phref":"http://videos.disneylatino.com/a-todo-ritmo","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"23:32","duration_sec":1412,"duration_iso":"T00H23M32S","badge":null,"primaryImageName":"thumb","id":"4ea245c2ba0ed3a150922e35","slug":"a-todo-ritmo-episodio-39-a-toda-trampa-para-padres","href":"http://videos.disneylatino.com/watch/a-todo-ritmo-episodio-39-a-toda-trampa-para-padres-4ea245c2ba0ed3a150922e35","title":"Episodio 39: A toda trampa para padres - A todo ritmo","thumb":"http://cdnvideo.dolimg.com/cdn_assets/ec4e06adc145b1e076f79711a265f56f695fa3dd.jpg","description":"\u00bfYa disfrutaste de este episodio en TV? Ahora rev\u00edvelo completo aqu\u00ed.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4ea245c2ba0ed3a150922e35","ptitle":"A todo ritmo","phref":"http://videos.disneylatino.com/a-todo-ritmo","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"22:33","duration_sec":1353,"duration_iso":"T00H22M33S","badge":null,"primaryImageName":"thumb","id":"4e88eac1cb389c12b5324010","slug":"jessie-episodio-13-la-princesa-y-el-cerebro-de-guisante","href":"http://videos.disneylatino.com/watch/jessie-episodio-13-la-princesa-y-el-cerebro-de-guisante-4e88eac1cb389c12b5324010","title":"Episodio 13: La princesa y el cerebro de guisante - Jessie","thumb":"http://cdnvideo.dolimg.com/cdn_assets/5c019e6402346155bd262e0ae14b431c729558c8.jpg","description":"En este episodio, tus personajes favoritos te atrapar\u00e1n una vez m\u00e1s. No dejes de verlo.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e88eac1cb389c12b5324010","ptitle":"Jessie","phref":"http://videos.disneylatino.com/jessie","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"22:50","duration_sec":1370,"duration_iso":"T00H22M50S","badge":null,"primaryImageName":"thumb","id":"4e77865330e66cca34f2bc2f","slug":"episodio-24-chayna-detective-programa-de-talentos","href":"http://videos.disneylatino.com/watch/episodio-24-chayna-detective-programa-de-talentos-4e77865330e66cca34f2bc2f","title":"Episodio 24: Chayna, detective - Programa de Talentos","thumb":"http://cdnvideo.dolimg.com/cdn_assets/17ba60824087c57dce5f7df287d8ea7af643ea4e.jpg","description":"\u00a1No te pierdas este episodio de \u201cPrograma de talentos\u201d!","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e77865330e66cca34f2bc2f","ptitle":"Programa de talentos","phref":"http://videos.disneylatino.com/programa-de-talentos","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"22:16","duration_sec":1336,"duration_iso":"T00H22M16S","badge":null,"primaryImageName":"thumb","id":"4e9fa7380500d367a1a1739b","slug":"gravity-falls-episodio-4-la-mano-que-mece-a-mabel","href":"http://videos.disneylatino.com/watch/gravity-falls-episodio-4-la-mano-que-mece-a-mabel-4e9fa7380500d367a1a1739b","title":"Episodio 4: La mano que mece a Mabel - Gravity Falls","thumb":"http://cdnvideo.dolimg.com/cdn_assets/a59cdc18ce99941ec721c205c319eec7942b2eea.jpg","description":"Este episodio es realmente imperdible. \u00a1M\u00edralo!","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e9fa7380500d367a1a1739b","ptitle":"Gravity Falls","phref":"http://disneychannel.disney.com/gravity-falls","watch_message":"Watch on Disney Channel!","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"22:48","duration_sec":1368,"duration_iso":"T00H22M48S","badge":null,"primaryImageName":"thumb","id":"4e91c5399068b37682e1b266","slug":"episodio-34-la-malteada-magica-de-milo-pecezuelos","href":"http://videos.disneylatino.com/watch/episodio-34-la-malteada-magica-de-milo-pecezuelos-4e91c5399068b37682e1b266","title":"Episodio 34: La malteada m\u00e1gica de Milo - Pecezuelos","thumb":"http://cdnvideo.dolimg.com/cdn_assets/68616044fba3828ddc136b9efce24dfa7c2ccd25.jpg","description":"Todo lo que te gusta de esta serie lo encontrar\u00e1s en este episodio.","vType":"Full Episode - TV","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e91c5399068b37682e1b266","ptitle":"Pecezuelos","phref":"http://videos.disneylatino.com/pecezuelos","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"}],"style":{"images":{}},"translations":{"see_all":"See All"},"see_all_text":"See All"},{"view":"slider","ref":"1-5","type":"video","count":6,"title":"Planeta X","data":[{"duration":"2:03","duration_sec":123,"duration_iso":"T00H02M03S","badge":null,"primaryImageName":"thumb","id":"4eca81687ca1ee7663a2156b","slug":"en-apuros-planet-x","href":"http://videos.disneylatino.com/watch/en-apuros-planet-x-4eca81687ca1ee7663a2156b","title":"En Apuros - Planeta X","thumb":"http://cdnvideo.dolimg.com/cdn_assets/9a1b1365843dd691888c31b9a7f3fab6446b650e.jpg","description":"\u00a1Todo est\u00e1 fuera de control! Mira todo lo que pasa en este gracioso video.","vType":"Clip","adPattern":"ACC","embedURL":"http://videos.disneylatino.com/embed/4eca81687ca1ee7663a2156b","ptitle":"Planeta X","phref":"http://videos.disneylatino.com/planeta-x","publish_date":"December 4, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"1:57","duration_sec":117,"duration_iso":"T00H01M57S","badge":null,"primaryImageName":"thumb","id":"4eca81706b949e7663a2156b","slug":"camion-planet-x","href":"http://videos.disneylatino.com/watch/camion-planet-x-4eca81706b949e7663a2156b","title":"Cami\u00f3n \u2013 Planet X","thumb":"http://cdnvideo.dolimg.com/cdn_assets/dc09a593368f47cd78f26e9a3e1932441d31a3e8.jpg","description":"\u00a1No te pierdas este fant\u00e1stico clip de Planet x!","vType":"Clip","adPattern":"ACC","embedURL":"http://videos.disneylatino.com/embed/4eca81706b949e7663a2156b","ptitle":"Planeta X","phref":"http://videos.disneylatino.com/planeta-x","publish_date":"December 4, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"2:03","duration_sec":123,"duration_iso":"T00H02M03S","badge":null,"primaryImageName":"thumb","id":"4eca816a27952e7663a2156b","slug":"duelo-de-jalapenos-planet-x","href":"http://videos.disneylatino.com/watch/duelo-de-jalapenos-planet-x-4eca816a27952e7663a2156b","title":"Duelo de jalape\u00f1os - Planeta X","thumb":"http://cdnvideo.dolimg.com/cdn_assets/e83cb96ffdaf391ad6e16f649f4b4170b1792c95.jpg","description":"\u00bfQuieres ver un gran duelo? En este video encontrar\u00e1s  lo que est\u00e1s buscando.","vType":"Clip","adPattern":"ACC","embedURL":"http://videos.disneylatino.com/embed/4eca816a27952e7663a2156b","ptitle":"Planeta X","phref":"http://videos.disneylatino.com/planeta-x","publish_date":"December 4, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"2:03","duration_sec":123,"duration_iso":"T00H02M03S","badge":null,"primaryImageName":"thumb","id":"4eca816cf2b41e7663a2156b","slug":"hipo-planet-x","href":"http://videos.disneylatino.com/watch/hipo-planet-x-4eca816cf2b41e7663a2156b","title":"Hipo - Planeta X","thumb":"http://cdnvideo.dolimg.com/cdn_assets/5d53637d8cac381ba0e08a9b0da7dfd846856ce4.jpg","description":"\u00a1Este video te dejar\u00e1 sin palabras!","vType":"Clip","adPattern":"ACC","embedURL":"http://videos.disneylatino.com/embed/4eca816cf2b41e7663a2156b","ptitle":"Planeta X","phref":"http://videos.disneylatino.com/planeta-x","publish_date":"December 4, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"2:04","duration_sec":124,"duration_iso":"T00H02M04S","badge":null,"primaryImageName":"thumb","id":"4eca816e56e29e7663a2156b","slug":"magnetismo-planet-x","href":"http://videos.disneylatino.com/watch/magnetismo-planet-x-4eca816e56e29e7663a2156b","title":"Magnetismo - Planeta X","thumb":"http://cdnvideo.dolimg.com/cdn_assets/52796867ba6010e84aae790be546ee7624f7df21.jpg","description":"\u00a1El poder del magnetismo se apodera de la escena! \u00bfQuieres ver lo que sucede?","vType":"Clip","adPattern":"ACC","embedURL":"http://videos.disneylatino.com/embed/4eca816e56e29e7663a2156b","ptitle":"Planeta X","phref":"http://videos.disneylatino.com/planeta-x","publish_date":"December 4, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"2:03","duration_sec":123,"duration_iso":"T00H02M03S","badge":null,"primaryImageName":"thumb","id":"4eca816b86b09e7663a2156b","slug":"cabello-planet-x","href":"http://videos.disneylatino.com/watch/cabello-planet-x-4eca816b86b09e7663a2156b","title":"Cabello - Planeta X","thumb":"http://cdnvideo.dolimg.com/cdn_assets/b67c221209d09acfa4b553f392ad104becf1dfc7.jpg","description":"\u00bfEst\u00e1n preparados para un cambio de look? Divi\u00e9rtete con este gracioso video.","vType":"Clip","adPattern":"ACC","embedURL":"http://videos.disneylatino.com/embed/4eca816b86b09e7663a2156b","ptitle":"Planeta X","phref":"http://videos.disneylatino.com/planeta-x","publish_date":"December 4, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"}],"style":{"images":{}},"translations":{"see_all":"See All"},"see_all_text":"See All"},{"view":"slider","ref":"1-6","type":"video","count":326,"title":"Violetta","data":[{"duration":"3:42","duration_sec":222,"duration_iso":"T00H03M42S","badge":null,"primaryImageName":"thumb","id":"4e8cf479811ac52564402b1c","slug":"violetta-el-gran-final-todos-cantan-esto-no-puede-terminar","href":"http://videos.disneylatino.com/watch/violetta-el-gran-final-todos-cantan-esto-no-puede-terminar-4e8cf479811ac52564402b1c","title":"El gran final: Todos cantan \u00a8Esto no puede terminar\u00a8 - Violetta","thumb":"http://cdnvideo.dolimg.com/cdn_assets/4d4887214816c37fa193dfd744ffe02d9802f314.jpg","description":"No te pierdas la canci\u00f3n final del episodio 80.","vType":"Music Video","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e8cf479811ac52564402b1c","ptitle":"Violetta","phref":"http://videos.disneylatino.com/violetta","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"3:13","duration_sec":193,"duration_iso":"T00H03M13S","badge":null,"primaryImageName":"thumb","id":"4e8970e825667df60af230bf","slug":"violetta-video-musical-si-es-por-amor","href":"http://videos.disneylatino.com/watch/violetta-video-musical-si-es-por-amor-4e8970e825667df60af230bf","title":"Si es por Amor: Video Musical - Violetta","thumb":"http://cdnvideo.dolimg.com/cdn_assets/4bfb6a98e414df50b304a3502ba7a754dbcbab69.jpg","description":"La peor pesadilla de Ludmila se hace realidad.","vType":"Music Video","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e8970e825667df60af230bf","ptitle":"Violetta","phref":"http://videos.disneylatino.com/violetta","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"4:39","duration_sec":279,"duration_iso":"T00H04M39S","badge":null,"primaryImageName":"thumb","id":"4e88a7bdcfbbc8e9cbfdc878","slug":"video-musical-nuestro-camino","href":"http://videos.disneylatino.com/watch/video-musical-nuestro-camino-4e88a7bdcfbbc8e9cbfdc878","title":"Video Musical: Nuestro Camino- Violetta ","thumb":"http://cdnvideo.dolimg.com/cdn_assets/3cd9a28215cba1632bb4c5b9ccb86064f9617273.jpg","description":"\u00a1Canta y baila esta canci\u00f3n de Violetta!","vType":"Music Video","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e88a7bdcfbbc8e9cbfdc878","ptitle":"Violetta","phref":"http://videos.disneylatino.com/violetta","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"1:01","duration_sec":61,"duration_iso":"T00H01M01S","badge":null,"primaryImageName":"thumb","id":"4e7c72fcdfd1a3203601a1ce","slug":"violetta-remixados","href":"http://videos.disneylatino.com/watch/violetta-remixados-4e7c72fcdfd1a3203601a1ce","title":"Remixados - Violetta","thumb":"http://cdnvideo.dolimg.com/cdn_assets/9eb4d599bfac1d591a316cebba0161de1fb7214f.jpg","description":"Las palabras sueltas de Vilu y el resto del elenco forman una canci\u00f3n muy particular.","vType":"Music Video","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e7c72fcdfd1a3203601a1ce","ptitle":"Violetta","phref":"http://videos.disneylatino.com/violetta","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"2:28","duration_sec":148,"duration_iso":"T00H02M28S","badge":null,"primaryImageName":"thumb","id":"4e8cf3ce160be52564402b1c","slug":"violetta-en-vivo-paraguay","href":"http://videos.disneylatino.com/watch/violetta-en-vivo-paraguay-4e8cf3ce160be52564402b1c","title":"Paraguay - Violetta en Vivo","thumb":"http://cdnvideo.dolimg.com/cdn_assets/ca2851a7724c2dc40eac571587c5153cc18fcdb8.jpg","description":"\u00a1Mira a los chicos de Violetta de gira en Paraguay!","vType":"Behind The Scenes","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e8cf3ce160be52564402b1c","ptitle":"Violetta","phref":"http://videos.disneylatino.com/violetta","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"3:12","duration_sec":192,"duration_iso":"T00H03M12S","badge":null,"primaryImageName":"thumb","id":"4e98013229bcaaef0b4a08d7","slug":"violetta-peligrosamente-bellas","href":"http://videos.disneylatino.com/watch/violetta-peligrosamente-bellas-4e98013229bcaaef0b4a08d7","title":"Peligrosamente Bellas - Violetta","thumb":"http://cdnvideo.dolimg.com/cdn_assets/e816287188f69c55bbe34af83cf0a962c0b60e10.jpg","description":"Ludmila y Nati muestran porqu\u00e9 son tan bellas.","vType":"Music Video","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e98013229bcaaef0b4a08d7","ptitle":"Violetta","phref":"http://videos.disneylatino.com/violetta","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"2:21","duration_sec":141,"duration_iso":"T00H02M21S","badge":null,"primaryImageName":"thumb","id":"4e680eb79bd469f38a4f4986","slug":"diario-de-rodaje-la-habitacion-de-violetta","href":"http://videos.disneylatino.com/watch/diario-de-rodaje-la-habitacion-de-violetta-4e680eb79bd469f38a4f4986","title":"La habitaci\u00f3n de Violetta: Diario de Rodaje - Violetta ","thumb":"http://cdnvideo.dolimg.com/cdn_assets/0feefe9947263897166d0507f9b5ee2b1aeb0add.jpg","description":"Martina Stoessel te muestra los rincones m\u00e1s especiales de la habitaci\u00f3n de Violetta.","vType":"Clip","adPattern":"ACC","embedURL":"http://videos.disneylatino.com/embed/4e680eb79bd469f38a4f4986","ptitle":"Violetta","phref":"http://videos.disneylatino.com/violetta","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"2:18","duration_sec":138,"duration_iso":"T00H02M18S","badge":null,"primaryImageName":"thumb","id":"4e680e08a0ef438d99da8638","slug":"on-beat","href":"http://videos.disneylatino.com/watch/on-beat-4e680e08a0ef438d99da8638","title":"On Beat - Violetta en vivo","thumb":"http://cdnvideo.dolimg.com/cdn_assets/56a1ef9d7e26c5948f85ba8c993959f0861bc698.jpg","description":"Sobre el escenario, el elenco comparte su versi\u00f3n en vivo de esta canci\u00f3n llena de ritmo.","vType":"Clip","adPattern":"ACC","embedURL":"http://videos.disneylatino.com/embed/4e680e08a0ef438d99da8638","ptitle":"Violetta","phref":"http://videos.disneylatino.com/violetta","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"0:50","duration_sec":50,"duration_iso":"T00H00M50S","badge":null,"primaryImageName":"thumb","id":"4e88a7bc6c3768e9cbfdc878","slug":"sebas-de-los-rock-bones-canta-paso-el-tiempo","href":"http://videos.disneylatino.com/watch/sebas-de-los-rock-bones-canta-paso-el-tiempo-4e88a7bc6c3768e9cbfdc878","title":"Sebas de los Rock Bones canta \u00a8Paso El Tiempo\u00a8- Violetta ","thumb":"http://cdnvideo.dolimg.com/cdn_assets/486266686bea913468dc35d3f34cd20a0008805c.jpg","description":"T\u00f3mate 5 minutos y disfruta de este gran momento musical de Violetta.","vType":"Music Video","adPattern":"C","embedURL":"http://videos.disneylatino.com/embed/4e88a7bc6c3768e9cbfdc878","ptitle":"Violetta","phref":"http://videos.disneylatino.com/violetta","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"3:25","duration_sec":205,"duration_iso":"T00H03M25S","badge":null,"primaryImageName":"thumb","id":"4e89638374eb05b9cbbedb1b","slug":"la-presentacion-de-francesca","href":"http://videos.disneylatino.com/watch/la-presentacion-de-francesca-4e89638374eb05b9cbbedb1b","title":"La presentaci\u00f3n de Francesca- Violetta ","thumb":"http://cdnvideo.dolimg.com/cdn_assets/8ba1a6e180277ef7e4014d5fa37cd40e63b7fdbc.jpg","description":"Fran canta \u00a8En mi Mundo\u00a8.","vType":"Music Video","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e89638374eb05b9cbbedb1b","ptitle":"Violetta","phref":"http://videos.disneylatino.com/violetta","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"2:36","duration_sec":156,"duration_iso":"T00H02M36S","badge":null,"primaryImageName":"thumb","id":"4eca3118c5ec76af94c3f2e8","slug":"latinoamerica-a-traves-de-mi-lente-xabiani-ponce-de-leon","href":"http://videos.disneylatino.com/watch/latinoamerica-a-traves-de-mi-lente-xabiani-ponce-de-leon-4eca3118c5ec76af94c3f2e8","title":"Latinoam\u00e9rica a trav\u00e9s de mi lente - Xabiani Ponce de Le\u00f3n ","thumb":"http://cdnvideo.dolimg.com/cdn_assets/da50816b28474ae49b24b20b029e5897f4bc708b.jpg","description":"\u00a1Exclusivo! No te pierdas el video que realiz\u00f3 Xabi del tour de \u00a8Violetta en Vivo\u00a8.","vType":"Music Video","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4eca3118c5ec76af94c3f2e8","ptitle":"Violetta","phref":"http://videos.disneylatino.com/violetta","publish_date":"December 4, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"5:36","duration_sec":336,"duration_iso":"T00H05M36S","badge":null,"primaryImageName":"thumb","id":"4ec3da4420067714ff367678","slug":"violetta-en-vivo-venezuela","href":"http://videos.disneylatino.com/watch/violetta-en-vivo-venezuela-4ec3da4420067714ff367678","title":"Venezuela \u2013 Violetta en Vivo","thumb":"http://cdnvideo.dolimg.com/cdn_assets/5bb81abee11fe8e4e5e914602677a3bc7c6653cf.jpg","description":"\u00a1No te pierdas el \u00faltimo show de Violetta en Vivo en Latinoam\u00e9rica!","vType":"Music Video","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4ec3da4420067714ff367678","ptitle":"Violetta","phref":"http://videos.disneylatino.com/violetta","publish_date":"December 2, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"1:33","duration_sec":93,"duration_iso":"T00H01M33S","badge":null,"primaryImageName":"thumb","id":"4eb00d02a8a6fe90b2cb67d3","slug":"tini-prepara-su-voz-violetta-en-vivo","href":"http://videos.disneylatino.com/watch/tini-prepara-su-voz-violetta-en-vivo-4eb00d02a8a6fe90b2cb67d3","title":"Tini prepara su voz - Violetta en Vivo","thumb":"http://cdnvideo.dolimg.com/cdn_assets/b2b213383f0704009f22bdd5c7b5371b0ca8815c.jpg","description":"No te pierdas a Martina Stoessel antes de salir a escena en San Pablo.","vType":"Clip","adPattern":"ACC","embedURL":"http://videos.disneylatino.com/embed/4eb00d02a8a6fe90b2cb67d3","ptitle":"Violetta","phref":"http://videos.disneylatino.com/violetta","publish_date":"November 27, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"1:28","duration_sec":88,"duration_iso":"T00H01M28S","badge":null,"primaryImageName":"thumb","id":"4eb00cf9b79a3e90b2cb67d3","slug":"qu-hay-en-la-valija-de-diego-violetta-en-vivo","href":"http://videos.disneylatino.com/watch/qu-hay-en-la-valija-de-diego-violetta-en-vivo-4eb00cf9b79a3e90b2cb67d3","title":"\u00bfQu\u00e9 hay en la valija de Diego? - Violetta en Vivo","thumb":"http://cdnvideo.dolimg.com/cdn_assets/d6e8373130296aa963f12d463795bee8ebbecc9e.jpg","description":"Los chicos de Violetta se preguntan qu\u00e9 hay dentro de su valija tan pesada. \u00a1No te lo pierdas!","vType":"Clip","adPattern":"ACC","embedURL":"http://videos.disneylatino.com/embed/4eb00cf9b79a3e90b2cb67d3","ptitle":"Violetta","phref":"http://videos.disneylatino.com/violetta","publish_date":"November 27, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"3:27","duration_sec":207,"duration_iso":"T00H03M27S","badge":null,"primaryImageName":"thumb","id":"4eb8975b870e964ab4d3bbf3","slug":"tini-y-jorge-cantan-nuestro-camino-violetta-en-vivo","href":"http://videos.disneylatino.com/watch/tini-y-jorge-cantan-nuestro-camino-violetta-en-vivo-4eb8975b870e964ab4d3bbf3","title":"Tini y Jorge cantan \u00a8Nuestro camino\u00a8 - Violetta en Vivo","thumb":"http://cdnvideo.dolimg.com/cdn_assets/e1dc387cef7125ab043864794f34d4f9c111c9e9.jpg","description":"\u00a1No te pierdas el detr\u00e1s de bastidores de la gira!","vType":"Clip","adPattern":"ACC","embedURL":"http://videos.disneylatino.com/embed/4eb8975b870e964ab4d3bbf3","ptitle":"Violetta","phref":"http://videos.disneylatino.com/violetta","publish_date":"November 27, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"3:17","duration_sec":197,"duration_iso":"T00H03M17S","badge":null,"primaryImageName":"thumb","id":"4eb8a4ce85350c99ba8a7ab6","slug":"tini-canta-hoy-somos-m-s-violetta-en-vivo","href":"http://videos.disneylatino.com/watch/tini-canta-hoy-somos-m-s-violetta-en-vivo-4eb8a4ce85350c99ba8a7ab6","title":"Tini canta \u00a8Hoy somos m\u00e1s\u00a8 - Violetta en Vivo","thumb":"http://cdnvideo.dolimg.com/cdn_assets/73042d8a7824cdd5a21db42897c8efa19cbd9d2b.jpg","description":"\u00a1No te pierdas el detr\u00e1s de bastidores de la gira!","vType":"Music Video","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4eb8a4ce85350c99ba8a7ab6","ptitle":"Violetta","phref":"http://videos.disneylatino.com/violetta","publish_date":"November 27, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"1:49","duration_sec":109,"duration_iso":"T00H01M49S","badge":null,"primaryImageName":"thumb","id":"4eb8a4c9620e7c99ba8a7ab6","slug":"probando-voces-violetta-en-vivo","href":"http://videos.disneylatino.com/watch/probando-voces-violetta-en-vivo-4eb8a4c9620e7c99ba8a7ab6","title":"Probando voces - Violetta en Vivo","thumb":"http://cdnvideo.dolimg.com/cdn_assets/4d98d1fc730e37ed67ab7de600cff38ef3f167e4.jpg","description":"El elenco de Violetta siempre calienta sus voces antes de salir a escena.","vType":"Behind The Scenes","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4eb8a4c9620e7c99ba8a7ab6","ptitle":"Violetta","phref":"http://videos.disneylatino.com/violetta","publish_date":"November 27, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"3:00","duration_sec":180,"duration_iso":"T00H03M00S","badge":null,"primaryImageName":"thumb","id":"4eb1267c861146e8eed23013","slug":"peru-violetta-en-vivo","href":"http://videos.disneylatino.com/watch/peru-violetta-en-vivo-4eb1267c861146e8eed23013","title":"Per\u00fa - Violetta en Vivo","thumb":"http://cdnvideo.dolimg.com/cdn_assets/88074c402173005aa91fc3dfcf286cf2410404e9.jpg","description":"\u00a1Mira a los chicos de Violetta de gira en Per\u00fa!","vType":"Music Video","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4eb1267c861146e8eed23013","ptitle":"Violetta","phref":"http://videos.disneylatino.com/violetta","publish_date":"November 27, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"1:46","duration_sec":106,"duration_iso":"T00H01M46S","badge":null,"primaryImageName":"thumb","id":"4eb8a4cbf7024c99ba8a7ab6","slug":"los-chicos-cantan-tienes-el-talento-violetta-en-vivo","href":"http://videos.disneylatino.com/watch/los-chicos-cantan-tienes-el-talento-violetta-en-vivo-4eb8a4cbf7024c99ba8a7ab6","title":"Los chicos cantan \u00a8Tienes el talento\u00a8 - Violetta en Vivo","thumb":"http://cdnvideo.dolimg.com/cdn_assets/6bbd0b0088d84918ba7b4e35150ad1c2a5950f55.jpg","description":"Desde sus camarines, los chicos de Violetta se divierten preparando sus voces.","vType":"Music Video","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4eb8a4cbf7024c99ba8a7ab6","ptitle":"Violetta","phref":"http://videos.disneylatino.com/violetta","publish_date":"November 27, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"1:12","duration_sec":72,"duration_iso":"T00H01M12S","badge":null,"primaryImageName":"thumb","id":"4eb897623c48564ab4d3bbf3","slug":"la-llegada-a-m-xico-violetta-en-vivo","href":"http://videos.disneylatino.com/watch/la-llegada-a-m-xico-violetta-en-vivo-4eb897623c48564ab4d3bbf3","title":"La llegada a M\u00e9xico - Violetta en Vivo","thumb":"http://cdnvideo.dolimg.com/cdn_assets/f473f8a9f494363f8d6f4f790f788149b5952c76.jpg","description":"\u00a1As\u00ed fue la llegada a M\u00e9xico!","vType":"Clip","adPattern":"ACC","embedURL":"http://videos.disneylatino.com/embed/4eb897623c48564ab4d3bbf3","ptitle":"Violetta","phref":"http://videos.disneylatino.com/violetta","publish_date":"November 27, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"1:29","duration_sec":89,"duration_iso":"T00H01M29S","badge":null,"primaryImageName":"thumb","id":"4eb897592063064ab4d3bbf3","slug":"tini-emocionada-en-m-xico-violetta-en-vivo","href":"http://videos.disneylatino.com/watch/tini-emocionada-en-m-xico-violetta-en-vivo-4eb897592063064ab4d3bbf3","title":"Tini emocionada en M\u00e9xico - Violetta en Vivo","thumb":"http://cdnvideo.dolimg.com/cdn_assets/c9ceca1a58d8764743a07d44610d1ebcdaf39f9c.jpg","description":"Martina no puede creer todo lo que est\u00e1 viviendo en la gira.","vType":"Clip","adPattern":"ACC","embedURL":"http://videos.disneylatino.com/embed/4eb897592063064ab4d3bbf3","ptitle":"Violetta","phref":"http://videos.disneylatino.com/violetta","publish_date":"November 27, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"2:36","duration_sec":156,"duration_iso":"T00H02M36S","badge":null,"primaryImageName":"thumb","id":"4eb00ce2eb6dfe90b2cb67d3","slug":"la-llegada-a-brasil-violetta-en-vivo","href":"http://videos.disneylatino.com/watch/la-llegada-a-brasil-violetta-en-vivo-4eb00ce2eb6dfe90b2cb67d3","title":"La llegada a Brasil - Violetta en Vivo","thumb":"http://cdnvideo.dolimg.com/cdn_assets/fddfc3f5c0f72f026c9ac5da9abe4ab593e87266.jpg","description":"As\u00ed fue la llegada del elenco de Violetta a San Pablo.","vType":"Clip","adPattern":"ACC","embedURL":"http://videos.disneylatino.com/embed/4eb00ce2eb6dfe90b2cb67d3","ptitle":"Violetta","phref":"http://videos.disneylatino.com/violetta","publish_date":"November 27, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"2:49","duration_sec":169,"duration_iso":"T00H02M49S","badge":null,"primaryImageName":"thumb","id":"4eb00cf275430e90b2cb67d3","slug":"la-familia-nascimento-violetta-en-vivo","href":"http://videos.disneylatino.com/watch/la-familia-nascimento-violetta-en-vivo-4eb00cf275430e90b2cb67d3","title":"La familia Nascimento - Violetta en Vivo","thumb":"http://cdnvideo.dolimg.com/cdn_assets/4c96441abdc9f41d9c6c33ee4801f212a0c82770.jpg","description":"En este emocionante video, Samuel recibe a su familia. Ellos lo ven actuar por primera vez en San Pablo. La emoci\u00f3n es tan grande que es imposible contener las l\u00e1grimas. No te lo puedes perder.","vType":"Clip","adPattern":"ACC","embedURL":"http://videos.disneylatino.com/embed/4eb00cf275430e90b2cb67d3","ptitle":"Violetta","phref":"http://videos.disneylatino.com/violetta","publish_date":"November 27, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"2:39","duration_sec":159,"duration_iso":"T00H02M39S","badge":null,"primaryImageName":"thumb","id":"4eb00d003ef99e90b2cb67d3","slug":"los-chicos-cantan-te-fazer-feliz-violetta-en-vivo","href":"http://videos.disneylatino.com/watch/los-chicos-cantan-te-fazer-feliz-violetta-en-vivo-4eb00d003ef99e90b2cb67d3","title":"Los chicos cantan \u00a8Te fazer feliz\u00a8 - Violetta en Vivo","thumb":"http://cdnvideo.dolimg.com/cdn_assets/b22120ec81e697b6aa2cfe101812210ff2e1d5e8.jpg","description":"Los varones de Violetta calientan sus voces cantando en el camarino.","vType":"Clip","adPattern":"ACC","embedURL":"http://videos.disneylatino.com/embed/4eb00d003ef99e90b2cb67d3","ptitle":"Violetta","phref":"http://videos.disneylatino.com/violetta","publish_date":"November 27, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"3:11","duration_sec":191,"duration_iso":"T00H03M11S","badge":null,"primaryImageName":"thumb","id":"4eb897642c40b64ab4d3bbf3","slug":"las-familias-de-visita-violetta-en-vivo","href":"http://videos.disneylatino.com/watch/las-familias-de-visita-violetta-en-vivo-4eb897642c40b64ab4d3bbf3","title":"Las familias de visita - Violetta en Vivo","thumb":"http://cdnvideo.dolimg.com/cdn_assets/6cb89ecfe38b2cdb915b45a32907ac07ed7a72bb.jpg","description":"Jorge, Xabi y Cande nos presentan a sus familias.","vType":"Clip","adPattern":"ACC","embedURL":"http://videos.disneylatino.com/embed/4eb897642c40b64ab4d3bbf3","ptitle":"Violetta","phref":"http://videos.disneylatino.com/violetta","publish_date":"November 27, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"1:23","duration_sec":83,"duration_iso":"T00H01M23S","badge":null,"primaryImageName":"thumb","id":"4eb00cd75d392e90b2cb67d3","slug":"ensayo-en-san-pablo-violetta-en-vivo","href":"http://videos.disneylatino.com/watch/ensayo-en-san-pablo-violetta-en-vivo-4eb00cd75d392e90b2cb67d3","title":"Ensayo en San Pablo - Violetta en Vivo","thumb":"http://cdnvideo.dolimg.com/cdn_assets/ee19ba7fc2d3d65f962b900c8503b4636e0bc140.jpg","description":"No te pierdas los preparativos para el gran show en Brasil.","vType":"Clip","adPattern":"ACC","embedURL":"http://videos.disneylatino.com/embed/4eb00cd75d392e90b2cb67d3","ptitle":"Violetta","phref":"http://videos.disneylatino.com/violetta","publish_date":"November 27, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"2:03","duration_sec":123,"duration_iso":"T00H02M03S","badge":null,"primaryImageName":"thumb","id":"4eb00ce4b7253e90b2cb67d3","slug":"el-maquillaje-de-tini-violetta-en-vivo","href":"http://videos.disneylatino.com/watch/el-maquillaje-de-tini-violetta-en-vivo-4eb00ce4b7253e90b2cb67d3","title":"El maquillaje de Tini - Violetta en Vivo","thumb":"http://cdnvideo.dolimg.com/cdn_assets/ef211544c64d33ad9e6ee2e728d8768e6a9f3591.jpg","description":"Aprende a maquillarte como Martina con este video detr\u00e1s de escena.","vType":"Clip","adPattern":"ACC","embedURL":"http://videos.disneylatino.com/embed/4eb00ce4b7253e90b2cb67d3","ptitle":"Violetta","phref":"http://videos.disneylatino.com/violetta","publish_date":"November 27, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"1:05","duration_sec":65,"duration_iso":"T00H01M05S","badge":null,"primaryImageName":"thumb","id":"4e984438b4999114c73bf874","slug":"leon-le-canta-a-lara","href":"http://videos.disneylatino.com/watch/leon-le-canta-a-lara-4e984438b4999114c73bf874","title":"Le\u00f3n le canta a Lara - Violetta","thumb":"http://cdnvideo.dolimg.com/cdn_assets/d997d408a41f142c4e85c68459db353807b918ac.jpg","description":"Le\u00f3n le dedica una bella versi\u00f3n de \u00a8Voy por ti\u00a8.","vType":"Music Video","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e984438b4999114c73bf874","ptitle":"Violetta","phref":"http://videos.disneylatino.com/violetta","publish_date":"November 18, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"2:12","duration_sec":132,"duration_iso":"T00H02M12S","badge":null,"primaryImageName":"thumb","id":"4e88b52b62a0704994af9f90","slug":"los-chicos-cantan-en-madrid-violetta","href":"http://videos.disneylatino.com/watch/los-chicos-cantan-en-madrid-violetta-4e88b52b62a0704994af9f90","title":"Los chicos cantan en Madrid - Violetta","thumb":"http://cdnvideo.dolimg.com/cdn_assets/c4d25b6fe99d383ac3b7379a296b982d37f33ef5.jpg","description":"Los chicos est\u00e1n en Espa\u00f1a y cantan una incre\u00edble versi\u00f3n de \u00a8Ser mejor\u00a8.","vType":"Music Video","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e88b52b62a0704994af9f90","ptitle":"Violetta","phref":"http://videos.disneylatino.com/violetta","publish_date":"November 18, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"1:00","duration_sec":60,"duration_iso":"T00H01M00S","badge":null,"primaryImageName":"thumb","id":"4e50f7c2a9708c8cd2ff9d76","slug":"violetta-diego-canta-yo-soy-as","href":"http://videos.disneylatino.com/watch/violetta-diego-canta-yo-soy-as-4e50f7c2a9708c8cd2ff9d76","title":"Diego canta \u00a8Yo soy as\u00ed\u00a8 - Violetta","thumb":"http://cdnvideo.dolimg.com/cdn_assets/794b7b0e327a6410f088829163ac3c1000827bbc.jpg","description":"\u00bfHas visto este momento musical con Diego? Te encantar\u00e1.","vType":"Clip","adPattern":"ACC","embedURL":"http://videos.disneylatino.com/embed/4e50f7c2a9708c8cd2ff9d76","ptitle":"Violetta","phref":"http://videos.disneylatino.com/violetta","publish_date":"November 18, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"2:38","duration_sec":158,"duration_iso":"T00H02M38S","badge":null,"primaryImageName":"thumb","id":"4e531d9b9d0c55d95ba73e0b","slug":"violetta-versus-trepadores-todo-terreno","href":"http://videos.disneylatino.com/watch/violetta-versus-trepadores-todo-terreno-4e531d9b9d0c55d95ba73e0b","title":"VERSUS: Trepadores todo terreno - Violetta","thumb":"http://cdnvideo.dolimg.com/cdn_assets/8abb1264ef2077833175b699769b650ab1f71d86.jpg","description":"Los chicos desatan su Spider-Man interior para ganar.","vType":"Clip","adPattern":"ACC","embedURL":"http://videos.disneylatino.com/embed/4e531d9b9d0c55d95ba73e0b","ptitle":"Violetta","phref":"http://videos.disneylatino.com/violetta","publish_date":"November 18, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"1:35","duration_sec":95,"duration_iso":"T00H01M35S","badge":null,"primaryImageName":"thumb","id":"4e97f3d0dc710bc5db7cee7b","slug":"ensayo-de-peligrosamente-bellas","href":"http://videos.disneylatino.com/watch/ensayo-de-peligrosamente-bellas-4e97f3d0dc710bc5db7cee7b","title":"Ensayo de \u00a8Peligrosamente Bellas\u00a8 - Violetta","thumb":"http://cdnvideo.dolimg.com/cdn_assets/c5766c4fbdcbafae52f3548b5aa42d5c1a1e0cdd.jpg","description":"Naty y Ludmila practican esta canci\u00f3n.","vType":"Music Video","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e97f3d0dc710bc5db7cee7b","ptitle":"Violetta","phref":"http://videos.disneylatino.com/violetta","publish_date":"November 14, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"2:18","duration_sec":138,"duration_iso":"T00H02M18S","badge":null,"primaryImageName":"thumb","id":"4e9653fded787542b841a302","slug":"violetta-canta-en-el-karaoke","href":"http://videos.disneylatino.com/watch/violetta-canta-en-el-karaoke-4e9653fded787542b841a302","title":"Violetta canta en el karaoke - Violetta","thumb":"http://cdnvideo.dolimg.com/cdn_assets/f65e9bdaa17b2ba3f9894d58ce275bbc827511be.jpg","description":"Vilu canta una hermosa versi\u00f3n de \u00a8Podemos\u00a8.","vType":"Music Video","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e9653fded787542b841a302","ptitle":"Violetta","phref":"http://videos.disneylatino.com/violetta","publish_date":"November 14, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"2:07","duration_sec":127,"duration_iso":"T00H02M07S","badge":null,"primaryImageName":"thumb","id":"4e5071a93e9d78063bf910d3","slug":"violetta-olga-y-ramallo-espacio-personal","href":"http://videos.disneylatino.com/watch/violetta-olga-y-ramallo-espacio-personal-4e5071a93e9d78063bf910d3","title":"Olga y Ramallo: Espacio Personal - Violetta","thumb":"http://cdnvideo.dolimg.com/cdn_assets/626caa95d7d43605a0e15d05688634436b46cade.jpg","description":"Los mejores momentos entre Ramallo y Olga.","vType":"Clip","adPattern":"ACC","embedURL":"http://videos.disneylatino.com/embed/4e5071a93e9d78063bf910d3","ptitle":"Violetta","phref":"http://videos.disneylatino.com/violetta","publish_date":"November 13, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"},{"duration":"3:00","duration_sec":180,"duration_iso":"T00H03M00S","badge":null,"primaryImageName":"thumb","id":"4ea823c2daf9379800644e8b","slug":"violetta-en-vivo-uruguay","href":"http://videos.disneylatino.com/watch/violetta-en-vivo-uruguay-4ea823c2daf9379800644e8b","title":"Uruguay - Violetta en Vivo","thumb":"http://cdnvideo.dolimg.com/cdn_assets/2fb379047febd7d25ff900d5bc53a57a757709cb.jpg","description":"\u00a1Mira a los chicos de Violetta de gira en Uruguay!","vType":"Music Video","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4ea823c2daf9379800644e8b","ptitle":"Violetta","phref":"http://videos.disneylatino.com/violetta","publish_date":"November 13, 2013","suppress_social":true,"cta_button_title":"Watch Now","type":"Video"}],"style":{"images":{}},"translations":{"see_all":"See All"},"see_all_text":"See All"},{"view":"slider","ref":"1-7","type":"video","count":12,"title":"Las Aventuras Subterr\u00e1neas de Swampy","data":[{"duration":"2:08","duration_sec":128,"duration_iso":"T00H02M08S","badge":null,"primaryImageName":"thumb","id":"4e680d98abc7838d99da8638","slug":"wheres-my-water-episodio-1-presentando-a-swampy","href":"http://videos.disneylatino.com/watch/wheres-my-water-episodio-1-presentando-a-swampy-4e680d98abc7838d99da8638","title":"Episodio 1: Presentando a Swampy - Where's My Water?","thumb":"http://cdnvideo.dolimg.com/cdn_assets/c319e02b4400574bcc2dc50e803e62c507a04a02.jpg","description":"Swampy confunde un extinguidor con una mochila-cohete.","vType":"Full Episode - Web","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e680d98abc7838d99da8638","ptitle":"Where's my water?","phref":"http://videos.disneylatino.com/where-s-my-water-presents-swampy-s-underground-adventures","cta_button_title":"Watch Now","type":"Video"},{"duration":"2:11","duration_sec":131,"duration_iso":"T00H02M11S","badge":null,"primaryImageName":"thumb","id":"4e680d9c3a0a638d99ca8638","slug":"wheres-my-water-episodio-2-marea-alta","href":"http://videos.disneylatino.com/watch/wheres-my-water-episodio-2-marea-alta-4e680d9c3a0a638d99ca8638","title":"Episodio 2: Marea alta - Where's My Water?","thumb":"http://cdnvideo.dolimg.com/cdn_assets/993ec2bd92c3b151a1290c4cfe2418c58f47a29b.jpg","description":"Una masa gigante de algas amenaza con secar la alcantarilla.","vType":"Full Episode - Web","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e680d9c3a0a638d99ca8638","ptitle":"Where's my water?","phref":"http://videos.disneylatino.com/where-s-my-water-presents-swampy-s-underground-adventures","cta_button_title":"Watch Now","type":"Video"},{"duration":"2:09","duration_sec":129,"duration_iso":"T00H02M09S","badge":null,"primaryImageName":"thumb","id":"4e680d9f4315238d696a8637","slug":"wheres-my-water-episodio-3-el-cambio-es-bueno","href":"http://videos.disneylatino.com/watch/wheres-my-water-episodio-3-el-cambio-es-bueno-4e680d9f4315238d696a8637","title":"Episodio 3: El cambio es bueno - Where's My Water?","thumb":"http://cdnvideo.dolimg.com/cdn_assets/31ca6aa7531836f919e1c0689fdfe214862f42e9.jpg","description":"La alcantarilla est\u00e1 dividida: Agua Limpia vs. M\u00e1s basura","vType":"Full Episode - Web","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e680d9f4315238d696a8637","ptitle":"Where's my water?","phref":"http://videos.disneylatino.com/where-s-my-water-presents-swampy-s-underground-adventures","cta_button_title":"Watch Now","type":"Video"},{"duration":"2:14","duration_sec":134,"duration_iso":"T00H02M14S","badge":null,"primaryImageName":"thumb","id":"4e680da3447f438d99ca8638","slug":"wheres-my-water-episodio-4-aguas-turbulentas","href":"http://videos.disneylatino.com/watch/wheres-my-water-episodio-4-aguas-turbulentas-4e680da3447f438d99ca8638","title":"Episodio 4: Aguas turbulentas - Where's My Water?","thumb":"http://cdnvideo.dolimg.com/cdn_assets/69782a50a08ec8ffcfbf204b60ccb4e752330e39.jpg","description":"Un par de lentes cae sobre la cola de Swampy y \u00e9sta cobra vida propia.","vType":"Full Episode - Web","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e680da3447f438d99ca8638","ptitle":"Where's my water?","phref":"http://videos.disneylatino.com/where-s-my-water-presents-swampy-s-underground-adventures","cta_button_title":"Watch Now","type":"Video"},{"duration":"2:19","duration_sec":139,"duration_iso":"T00H02M19S","badge":null,"primaryImageName":"thumb","id":"4e680da65a5ce5ef38f62808","slug":"wheres-my-water-episodio-5-bajo-presion","href":"http://videos.disneylatino.com/watch/wheres-my-water-episodio-5-bajo-presion-4e680da65a5ce5ef38f62808","title":"Episodio 5: Bajo presi\u00f3n - Where's My Water?","thumb":"http://cdnvideo.dolimg.com/cdn_assets/58d5d3ef87c3de91b2449217bef1a0d5ab2c6481.jpg","description":"Cuando Cranky se traga una radio, \u00a1comienza la fiesta en la alcantarilla!","vType":"Full Episode - Web","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e680da65a5ce5ef38f62808","ptitle":"Where's my water?","phref":"http://videos.disneylatino.com/where-s-my-water-presents-swampy-s-underground-adventures","cta_button_title":"Watch Now","type":"Video"},{"duration":"2:19","duration_sec":139,"duration_iso":"T00H02M19S","badge":null,"primaryImageName":"thumb","id":"4e680da972ff35ef38d62808","slug":"wheres-my-water-episodio-6-a-secar","href":"http://videos.disneylatino.com/watch/wheres-my-water-episodio-6-a-secar-4e680da972ff35ef38d62808","title":"Episodio 6: A secar - Where's My Water?","thumb":"http://cdnvideo.dolimg.com/cdn_assets/00ec10e847b26d645278db30ad5f3c950b6e548e.jpg","description":"Cuando la alcantarilla se seca misteriosamente, Swampy se propone encontrar la causa.","vType":"Full Episode - Web","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e680da972ff35ef38d62808","ptitle":"Where's my water?","phref":"http://videos.disneylatino.com/where-s-my-water-presents-swampy-s-underground-adventures","cta_button_title":"Watch Now","type":"Video"},{"duration":"2:15","duration_sec":135,"duration_iso":"T00H02M15S","badge":null,"primaryImageName":"thumb","id":"4e680dac6063138d99ca8638","slug":"wheres-my-water-episodio-7-hundirse-o-nadar","href":"http://videos.disneylatino.com/watch/wheres-my-water-episodio-7-hundirse-o-nadar-4e680dac6063138d99ca8638","title":"Episodio 7: Hundirse o nadar - Where's My Water?","thumb":"http://cdnvideo.dolimg.com/cdn_assets/4e80502b475ce6d366eafcf143d0cb13e6ba483b.jpg","description":"Swampy y Cranky se vuelven muy competitivos.","vType":"Full Episode - Web","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e680dac6063138d99ca8638","ptitle":"Where's my water?","phref":"http://videos.disneylatino.com/where-s-my-water-presents-swampy-s-underground-adventures","cta_button_title":"Watch Now","type":"Video"},{"duration":"2:16","duration_sec":136,"duration_iso":"T00H02M16S","badge":null,"primaryImageName":"thumb","id":"4e680db03ae7c9f42aff4987","slug":"wheres-my-water-episodio-8-estiramientos","href":"http://videos.disneylatino.com/watch/wheres-my-water-episodio-8-estiramientos-4e680db03ae7c9f42aff4987","title":"Episodio 8: Estiramientos - Where's My Water?","thumb":"http://cdnvideo.dolimg.com/cdn_assets/2830e76dba28a13095776fbac6745d2874b5bf2d.jpg","description":"Un frasco de pegamento pone a todos en una situaci\u00f3n... pegajosa.","vType":"Full Episode - Web","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e680db03ae7c9f42aff4987","ptitle":"Where's my water?","phref":"http://videos.disneylatino.com/where-s-my-water-presents-swampy-s-underground-adventures","cta_button_title":"Watch Now","type":"Video"},{"duration":"1:48","duration_sec":108,"duration_iso":"T00H01M48S","badge":null,"primaryImageName":"thumb","id":"4e680db34bd0f9f42b5f4987","slug":"wheres-my-water-episodio-9-felices-fiestas","href":"http://videos.disneylatino.com/watch/wheres-my-water-episodio-9-felices-fiestas-4e680db34bd0f9f42b5f4987","title":"Episodio 9: Felices Fiestas - Where's My Water?","thumb":"http://cdnvideo.dolimg.com/cdn_assets/bcdab8262cd6892b7b41855586429233e537396d.jpg","description":"\u00bfCu\u00e1nta diversi\u00f3n puede haber en una alcantarilla congelada?","vType":"Full Episode - Web","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e680db34bd0f9f42b5f4987","ptitle":"Where's my water?","phref":"http://videos.disneylatino.com/where-s-my-water-presents-swampy-s-underground-adventures","cta_button_title":"Watch Now","type":"Video"},{"duration":"2:06","duration_sec":126,"duration_iso":"T00H02M06S","badge":null,"primaryImageName":"thumb","id":"4e680db65e8df9f42b5f4987","slug":"wheres-my-water-episodio-10-punto-de-hervor","href":"http://videos.disneylatino.com/watch/wheres-my-water-episodio-10-punto-de-hervor-4e680db65e8df9f42b5f4987","title":"Episodio 10: Punto de hervor - Where's My Water?","thumb":"http://cdnvideo.dolimg.com/cdn_assets/826b12dcdba957a7dc7b7900aebad07eaa922df4.jpg","description":"Un globo flota bajo tierra y confunde a todos los cocodrilos.","vType":"Full Episode - Web","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e680db65e8df9f42b5f4987","ptitle":"Where's my water?","phref":"http://videos.disneylatino.com/where-s-my-water-presents-swampy-s-underground-adventures","cta_button_title":"Watch Now","type":"Video"},{"duration":"2:00","duration_sec":120,"duration_iso":"T00H02M00S","badge":null,"primaryImageName":"thumb","id":"4e680db9806805ef38d62808","slug":"wheres-my-water-episodio-11-nivel-sin-nombre","href":"http://videos.disneylatino.com/watch/wheres-my-water-episodio-11-nivel-sin-nombre-4e680db9806805ef38d62808","title":"Episodio 11: Nivel sin nombre - Where's My Water?","thumb":"http://cdnvideo.dolimg.com/cdn_assets/938f47f70d4d1759c3747efb54d9628883f6e082.jpg","description":"Swampy encuentra aventuras al otro lado del espejo.","vType":"Full Episode - Web","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e680db9806805ef38d62808","ptitle":"Where's my water?","phref":"http://videos.disneylatino.com/where-s-my-water-presents-swampy-s-underground-adventures","cta_button_title":"Watch Now","type":"Video"},{"duration":"2:05","duration_sec":125,"duration_iso":"T00H02M05S","badge":null,"primaryImageName":"thumb","id":"4e680dbcda6f05ef01262808","slug":"wheres-my-water-episodio-12-ducky","href":"http://videos.disneylatino.com/watch/wheres-my-water-episodio-12-ducky-4e680dbcda6f05ef01262808","title":"Episodio 12: Ducky - Where's My Water?","thumb":"http://cdnvideo.dolimg.com/cdn_assets/41bd3f237ee923e935bc76e7be1362bec24105d7.jpg","description":"Una familia de patos de verdad pasa por la alcantarilla y se lleva a Ducky.","vType":"Full Episode - Web","adPattern":"AC","embedURL":"http://videos.disneylatino.com/embed/4e680dbcda6f05ef01262808","ptitle":"Where's my water?","phref":"http://videos.disneylatino.com/where-s-my-water-presents-swampy-s-underground-adventures","cta_button_title":"Watch Now","type":"Video"}],"style":{"images":{}},"translations":{"see_all":"See All"},"see_all_text":"See All"},{"view":"recommended","ref":"1-9","type":"collection","count":4,"title":"Colecciones de Videos","data":[{"id":"4ea9ce4ae94de7d1a408809b","slug":"phineas-y-ferb","href":"http://videos.disneylatino.com/collections/phineas-y-ferb-4ea9ce4ae94de7d1a408809b","title":"Phineas y Ferb","square":"http://cdnvideo.dolimg.com/cdn_assets/2dc1ca17fb07967cb93a2fa614a7c555bf759a1f.jpg","description":"\u00bfQu\u00e9 vamos a hacer hoy? \u00a1Disfrutar de esta colecci\u00f3n de videos extraordinarios de Phineas y Ferb, por supuesto!","short_desc":"\u00bfQu\u00e9 vamos a hacer hoy? \u00a1Disfrutar de esta colecci\u00f3n de videos extraordinarios de Phineas y Ferb, por supuesto!","type":"Collection"},{"id":"4ea9ca53c8463450795f9637","slug":"violetta","href":"http://videos.disneylatino.com/collections/violetta-4ea9ca53c8463450795f9637","title":"Violetta","square":"http://cdnvideo.dolimg.com/cdn_assets/4bc3b8cf49a161ebd16861df3bfbb914a4310a07.jpg","description":"Entra al mundo de Violetta con esta colecci\u00f3n imperdible de canciones, escenas y secretos de backstage que te emocionar\u00e1n.","short_desc":"Entra al mundo de Violetta con esta colecci\u00f3n imperdible de canciones, escenas y secretos de backstage que te emocionar\u00e1n.","type":"Collection"},{"id":"4ea9cc15b0a2354755ebdd59","slug":"disney-channel","href":"http://videos.disneylatino.com/collections/disney-channel-4ea9cc15b0a2354755ebdd59","title":"Disney Channel","square":"http://cdnvideo.dolimg.com/cdn_assets/80c72572454c91d03b9f4535b81631f667f224ab.jpg","description":"Una selecci\u00f3n imperdible de episodios, videos especiales y m\u00e1s momentos divertidos y emocionantes.","short_desc":"Una selecci\u00f3n imperdible de episodios, videos especiales y m\u00e1s momentos divertidos y emocionantes.","type":"Collection"},{"id":"4eaaaa998c48a9b0b24b63d8","slug":"disney-xd","href":"http://videos.disneylatino.com/collections/disney-xd-4eaaaa998c48a9b0b24b63d8","title":"Disney XD","square":"http://cdnvideo.dolimg.com/cdn_assets/de803e3aee6a60e861da3d6db28464f35a9d7e7f.jpg","description":"Una selecci\u00f3n de videos, especialmente preparada para los fans de Disney XD.","short_desc":"Una selecci\u00f3n de videos, especialmente preparada para los fans de Disney XD.","type":"Collection"}],"style":{"images":{}}}],"style":{"takeover":{"image":null}},"adData":{"config":{"targeting":{"unit":"dol","siteSection":"series","contentType":"section","pageName":"series","contentId":"4e942d59fcaf7a6ba8030179","property":null,"propertyId":null},"web":"/8211/FUSION_VIDEOS/Series","mobile":"/8211/FUSION_VIDEOS/Series"},"cds":0,"disableAds":false,"pda":true,"adSystem":"dfp"},"market_code":"latino","branding":"Disney Entertainment"}:(function(){var a=document.getElementsByTagName("html")[0];a.setAttribute("class",a.getAttribute("class")+" grill-error")})()</script>
    data = scrapertools.find_single_match(data,'Grill.burger\=(.*?)\:\(function\(\)')
    logger.info("data="+repr(data))
    data_json = jsontools.load_json(data)
    logger.info("data_json="+repr(data_json))

    for stack_element in data_json["stack"]:

        if stack_element["type"]=="video":

            videos = stack_element["data"]
            
            for video in videos:
                title = video["title"]+" ("+video["duration"]+")"
                url = video["href"]
                thumbnail = video["thumb"]
                plot = video["description"]
                itemlist.append( Item(channel=__channel__, action="play", server="disneylatino", title=title, url=url, thumbnail=thumbnail, plot=plot, folder=False) )

    return itemlist
