# -*- coding: utf-8 -*-
#------------------------------------------------------------
# pelisalacarta - XBMC Plugin
# http://blog.tvalacarta.info/plugin-xbmc/pelisalacarta/
#------------------------------------------------------------
import urlparse,urllib2,urllib,re,os,sys

from core import config
from core import logger
from core.item import Item
from core import scrapertools

__channel__ = "buscador"

logger.info("pelisalacarta.channels.buscador init")

DEBUG = True

def isGeneric():
    return True

def mainlist(item,preferred_thumbnail="squares"):
    logger.info("pelisalacarta.channels.buscador mainlist")

    itemlist = []
    itemlist.append( Item(channel=__channel__ , action="search"  , title="Realizar nueva búsqueda..." ))

    saved_searches_list = get_saved_searches(item.channel)

    for saved_search_text in saved_searches_list:
        itemlist.append( Item(channel=__channel__ , action="do_search"  , title=' "'+saved_search_text+'"', extra=saved_search_text ))

    if len(saved_searches_list)>0:
        itemlist.append( Item(channel=__channel__ , action="clear_saved_searches"  , title="Borrar búsquedas guardadas" ))

    return itemlist

# Al llamar a esta función, el sistema pedirá primero el texto a buscar
# y lo pasará en el parámetro "tecleado"
def search(item,tecleado):

    if tecleado!="":
        save_search(item.channel,tecleado)

    item.extra = tecleado
    return do_search(item)

# Esta es la función que realmente realiza la búsqueda
def do_search(item):

    tecleado = item.extra

    itemlist = []

    import os
    import glob
    import imp
    
    exclude_data_file = os.path.join( config.get_data_path() , "global_search_exclusion.txt")
    logger.info("exclude_data_file="+exclude_data_file)

    channels_path = os.path.join( config.get_runtime_path() , "channels" , '*.py' )
    logger.info("channels_path="+channels_path)

    excluir=""
    if os.path.exists(exclude_data_file):
        fileexclude = open(exclude_data_file,"r")
        excluir= fileexclude.read()
        fileexclude.close()
    else:
        excluir = "seriesly\n"
        fileexclude = open(exclude_data_file,"w")
        fileexclude.write(excluir)
        fileexclude.close()

    for infile in glob.glob(channels_path):

        basename = os.path.basename(infile)
        basename_without_extension = basename[:-3]
        
        if basename_without_extension not in excluir:

            logger.info("pelisalacarta.channels.buscador do_search_results, Intentado busqueda en " + basename_without_extension + " de "+ tecleado)
            try:
                # http://docs.python.org/library/imp.html?highlight=imp#module-imp
                obj = imp.load_source(basename_without_extension, infile)
                logger.info("pelisalacarta.channels.buscador do_search_results, cargado " + basename_without_extension + " de "+ infile)
                itemlist.extend( obj.search( Item() , tecleado) )
            except:
                import traceback
                logger.error( traceback.format_exc() )

        else:
            logger.info("pelisalacarta.channels.buscador do_search_results, Excluido server " + basename_without_extension)

    return itemlist

def save_search(channel,text):

    saved_searches_limit = ( 10, 20, 30, 40, )[ int( config.get_setting( "saved_searches_limit" ) ) ]

    if os.path.exists(os.path.join( config.get_data_path() , "saved_searches.txt" )):
        f = open( os.path.join( config.get_data_path() , "saved_searches.txt" ) , "r" )
        saved_searches_list = f.readlines()
        f.close()
    else:
        saved_searches_list = []

    saved_searches_list.append(text)

    if len(saved_searches_list)>=saved_searches_limit:
        # Corta la lista por el principio, eliminando los más recientes
        saved_searches_list = saved_searches_list[-saved_searches_limit:]

    f = open( os.path.join( config.get_data_path() , "saved_searches.txt" ) , "w" )
    for saved_search in saved_searches_list:
        f.write(saved_search+"\n")
    f.close()

def clear_saved_searches():

    f = open( os.path.join( config.get_data_path() , "saved_searches.txt" ) , "w" )
    f.write("")
    f.close()

def get_saved_searches(channel):

    if os.path.exists(os.path.join( config.get_data_path() , "saved_searches.txt" )):
        f = open( os.path.join( config.get_data_path() , "saved_searches.txt" ) , "r" )
        saved_searches_list = f.readlines()
        f.close()
    else:
        saved_searches_list = []
    
    # Invierte la lista, para que el último buscado salga el primero
    saved_searches_list.reverse()
    
    return saved_searches_list
